package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListQuotaApplicationsDetailForTemplate invokes the quotas.ListQuotaApplicationsDetailForTemplate API synchronously
func (client *Client) ListQuotaApplicationsDetailForTemplate(request *ListQuotaApplicationsDetailForTemplateRequest) (response *ListQuotaApplicationsDetailForTemplateResponse, err error) {
	response = CreateListQuotaApplicationsDetailForTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// ListQuotaApplicationsDetailForTemplateWithChan invokes the quotas.ListQuotaApplicationsDetailForTemplate API asynchronously
func (client *Client) ListQuotaApplicationsDetailForTemplateWithChan(request *ListQuotaApplicationsDetailForTemplateRequest) (<-chan *ListQuotaApplicationsDetailForTemplateResponse, <-chan error) {
	responseChan := make(chan *ListQuotaApplicationsDetailForTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListQuotaApplicationsDetailForTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListQuotaApplicationsDetailForTemplateWithCallback invokes the quotas.ListQuotaApplicationsDetailForTemplate API asynchronously
func (client *Client) ListQuotaApplicationsDetailForTemplateWithCallback(request *ListQuotaApplicationsDetailForTemplateRequest, callback func(response *ListQuotaApplicationsDetailForTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListQuotaApplicationsDetailForTemplateResponse
		var err error
		defer close(result)
		response, err = client.ListQuotaApplicationsDetailForTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListQuotaApplicationsDetailForTemplateRequest is the request struct for api ListQuotaApplicationsDetailForTemplate
type ListQuotaApplicationsDetailForTemplateRequest struct {
	*requests.RpcRequest
	ProductCode             string           `position:"Body" name:"ProductCode"`
	QuotaActionCode         string           `position:"Body" name:"QuotaActionCode"`
	BatchQuotaApplicationId string           `position:"Body" name:"BatchQuotaApplicationId"`
	NextToken               string           `position:"Body" name:"NextToken"`
	QuotaCategory           string           `position:"Body" name:"QuotaCategory"`
	OriginalContext         string           `position:"Body" name:"OriginalContext"`
	AliyunUid               string           `position:"Body" name:"AliyunUid"`
	MaxResults              requests.Integer `position:"Body" name:"MaxResults"`
	Status                  string           `position:"Body" name:"Status"`
}

// ListQuotaApplicationsDetailForTemplateResponse is the response struct for api ListQuotaApplicationsDetailForTemplate
type ListQuotaApplicationsDetailForTemplateResponse struct {
	*responses.BaseResponse
	NextToken         string                           `json:"NextToken" xml:"NextToken"`
	TotalCount        int                              `json:"TotalCount" xml:"TotalCount"`
	MaxResults        int                              `json:"MaxResults" xml:"MaxResults"`
	RequestId         string                           `json:"RequestId" xml:"RequestId"`
	QuotaApplications []QuotaBatchApplicationDetailVos `json:"QuotaApplications" xml:"QuotaApplications"`
}

// CreateListQuotaApplicationsDetailForTemplateRequest creates a request to invoke ListQuotaApplicationsDetailForTemplate API
func CreateListQuotaApplicationsDetailForTemplateRequest() (request *ListQuotaApplicationsDetailForTemplateRequest) {
	request = &ListQuotaApplicationsDetailForTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "ListQuotaApplicationsDetailForTemplate", "quotas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListQuotaApplicationsDetailForTemplateResponse creates a response to parse from ListQuotaApplicationsDetailForTemplate response
func CreateListQuotaApplicationsDetailForTemplateResponse() (response *ListQuotaApplicationsDetailForTemplateResponse) {
	response = &ListQuotaApplicationsDetailForTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
