package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAuditLog invokes the quickbi_public.QueryAuditLog API synchronously
func (client *Client) QueryAuditLog(request *QueryAuditLogRequest) (response *QueryAuditLogResponse, err error) {
	response = CreateQueryAuditLogResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAuditLogWithChan invokes the quickbi_public.QueryAuditLog API asynchronously
func (client *Client) QueryAuditLogWithChan(request *QueryAuditLogRequest) (<-chan *QueryAuditLogResponse, <-chan error) {
	responseChan := make(chan *QueryAuditLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAuditLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAuditLogWithCallback invokes the quickbi_public.QueryAuditLog API asynchronously
func (client *Client) QueryAuditLogWithCallback(request *QueryAuditLogRequest, callback func(response *QueryAuditLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAuditLogResponse
		var err error
		defer close(result)
		response, err = client.QueryAuditLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAuditLogRequest is the request struct for api QueryAuditLog
type QueryAuditLogRequest struct {
	*requests.RpcRequest
	AccessPoint   string `position:"Query" name:"AccessPoint"`
	StartDate     string `position:"Query" name:"StartDate"`
	LogType       string `position:"Query" name:"LogType"`
	SignType      string `position:"Query" name:"SignType"`
	ResourceType  string `position:"Query" name:"ResourceType"`
	OperatorTypes string `position:"Query" name:"OperatorTypes"`
	EndDate       string `position:"Query" name:"EndDate"`
	OperatorId    string `position:"Query" name:"OperatorId"`
	WorkspaceId   string `position:"Query" name:"WorkspaceId"`
}

// QueryAuditLogResponse is the response struct for api QueryAuditLog
type QueryAuditLogResponse struct {
	*responses.BaseResponse
	RequestId string              `json:"RequestId" xml:"RequestId"`
	Success   bool                `json:"Success" xml:"Success"`
	Result    []LogApiResultModel `json:"Result" xml:"Result"`
}

// CreateQueryAuditLogRequest creates a request to invoke QueryAuditLog API
func CreateQueryAuditLogRequest() (request *QueryAuditLogRequest) {
	request = &QueryAuditLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "QueryAuditLog", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryAuditLogResponse creates a response to parse from QueryAuditLog response
func CreateQueryAuditLogResponse() (response *QueryAuditLogResponse) {
	response = &QueryAuditLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
