package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelAuthorizationMenu invokes the quickbi_public.CancelAuthorizationMenu API synchronously
func (client *Client) CancelAuthorizationMenu(request *CancelAuthorizationMenuRequest) (response *CancelAuthorizationMenuResponse, err error) {
	response = CreateCancelAuthorizationMenuResponse()
	err = client.DoAction(request, response)
	return
}

// CancelAuthorizationMenuWithChan invokes the quickbi_public.CancelAuthorizationMenu API asynchronously
func (client *Client) CancelAuthorizationMenuWithChan(request *CancelAuthorizationMenuRequest) (<-chan *CancelAuthorizationMenuResponse, <-chan error) {
	responseChan := make(chan *CancelAuthorizationMenuResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelAuthorizationMenu(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelAuthorizationMenuWithCallback invokes the quickbi_public.CancelAuthorizationMenu API asynchronously
func (client *Client) CancelAuthorizationMenuWithCallback(request *CancelAuthorizationMenuRequest, callback func(response *CancelAuthorizationMenuResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelAuthorizationMenuResponse
		var err error
		defer close(result)
		response, err = client.CancelAuthorizationMenu(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelAuthorizationMenuRequest is the request struct for api CancelAuthorizationMenu
type CancelAuthorizationMenuRequest struct {
	*requests.RpcRequest
	DataPortalId string `position:"Query" name:"DataPortalId"`
	AccessPoint  string `position:"Query" name:"AccessPoint"`
	MenuIds      string `position:"Query" name:"MenuIds"`
	SignType     string `position:"Query" name:"SignType"`
	UserGroupIds string `position:"Query" name:"UserGroupIds"`
	UserIds      string `position:"Query" name:"UserIds"`
}

// CancelAuthorizationMenuResponse is the response struct for api CancelAuthorizationMenu
type CancelAuthorizationMenuResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    int    `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCancelAuthorizationMenuRequest creates a request to invoke CancelAuthorizationMenu API
func CreateCancelAuthorizationMenuRequest() (request *CancelAuthorizationMenuRequest) {
	request = &CancelAuthorizationMenuRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "CancelAuthorizationMenu", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelAuthorizationMenuResponse creates a response to parse from CancelAuthorizationMenu response
func CreateCancelAuthorizationMenuResponse() (response *CancelAuthorizationMenuResponse) {
	response = &CancelAuthorizationMenuResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
