package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteWarningStrategyConfig invokes the qualitycheck.DeleteWarningStrategyConfig API synchronously
func (client *Client) DeleteWarningStrategyConfig(request *DeleteWarningStrategyConfigRequest) (response *DeleteWarningStrategyConfigResponse, err error) {
	response = CreateDeleteWarningStrategyConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteWarningStrategyConfigWithChan invokes the qualitycheck.DeleteWarningStrategyConfig API asynchronously
func (client *Client) DeleteWarningStrategyConfigWithChan(request *DeleteWarningStrategyConfigRequest) (<-chan *DeleteWarningStrategyConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteWarningStrategyConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteWarningStrategyConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteWarningStrategyConfigWithCallback invokes the qualitycheck.DeleteWarningStrategyConfig API asynchronously
func (client *Client) DeleteWarningStrategyConfigWithCallback(request *DeleteWarningStrategyConfigRequest, callback func(response *DeleteWarningStrategyConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteWarningStrategyConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteWarningStrategyConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteWarningStrategyConfigRequest is the request struct for api DeleteWarningStrategyConfig
type DeleteWarningStrategyConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
	BaseMeAgentId   requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// DeleteWarningStrategyConfigResponse is the response struct for api DeleteWarningStrategyConfig
type DeleteWarningStrategyConfigResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteWarningStrategyConfigRequest creates a request to invoke DeleteWarningStrategyConfig API
func CreateDeleteWarningStrategyConfigRequest() (request *DeleteWarningStrategyConfigRequest) {
	request = &DeleteWarningStrategyConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "DeleteWarningStrategyConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteWarningStrategyConfigResponse creates a response to parse from DeleteWarningStrategyConfig response
func CreateDeleteWarningStrategyConfigResponse() (response *DeleteWarningStrategyConfigResponse) {
	response = &DeleteWarningStrategyConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
