package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddRuleCategory invokes the qualitycheck.AddRuleCategory API synchronously
func (client *Client) AddRuleCategory(request *AddRuleCategoryRequest) (response *AddRuleCategoryResponse, err error) {
	response = CreateAddRuleCategoryResponse()
	err = client.DoAction(request, response)
	return
}

// AddRuleCategoryWithChan invokes the qualitycheck.AddRuleCategory API asynchronously
func (client *Client) AddRuleCategoryWithChan(request *AddRuleCategoryRequest) (<-chan *AddRuleCategoryResponse, <-chan error) {
	responseChan := make(chan *AddRuleCategoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddRuleCategory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddRuleCategoryWithCallback invokes the qualitycheck.AddRuleCategory API asynchronously
func (client *Client) AddRuleCategoryWithCallback(request *AddRuleCategoryRequest, callback func(response *AddRuleCategoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddRuleCategoryResponse
		var err error
		defer close(result)
		response, err = client.AddRuleCategory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddRuleCategoryRequest is the request struct for api AddRuleCategory
type AddRuleCategoryRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
	BaseMeAgentId   requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// AddRuleCategoryResponse is the response struct for api AddRuleCategory
type AddRuleCategoryResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAddRuleCategoryRequest creates a request to invoke AddRuleCategory API
func CreateAddRuleCategoryRequest() (request *AddRuleCategoryRequest) {
	request = &AddRuleCategoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "AddRuleCategory", "", "")
	request.Method = requests.POST
	return
}

// CreateAddRuleCategoryResponse creates a response to parse from AddRuleCategory response
func CreateAddRuleCategoryResponse() (response *AddRuleCategoryResponse) {
	response = &AddRuleCategoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
