package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeResolverAvailableZones invokes the pvtz.DescribeResolverAvailableZones API synchronously
func (client *Client) DescribeResolverAvailableZones(request *DescribeResolverAvailableZonesRequest) (response *DescribeResolverAvailableZonesResponse, err error) {
	response = CreateDescribeResolverAvailableZonesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeResolverAvailableZonesWithChan invokes the pvtz.DescribeResolverAvailableZones API asynchronously
func (client *Client) DescribeResolverAvailableZonesWithChan(request *DescribeResolverAvailableZonesRequest) (<-chan *DescribeResolverAvailableZonesResponse, <-chan error) {
	responseChan := make(chan *DescribeResolverAvailableZonesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeResolverAvailableZones(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeResolverAvailableZonesWithCallback invokes the pvtz.DescribeResolverAvailableZones API asynchronously
func (client *Client) DescribeResolverAvailableZonesWithCallback(request *DescribeResolverAvailableZonesRequest, callback func(response *DescribeResolverAvailableZonesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeResolverAvailableZonesResponse
		var err error
		defer close(result)
		response, err = client.DescribeResolverAvailableZones(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeResolverAvailableZonesRequest is the request struct for api DescribeResolverAvailableZones
type DescribeResolverAvailableZonesRequest struct {
	*requests.RpcRequest
	ResolverRegionId string `position:"Query" name:"ResolverRegionId"`
	UserClientIp     string `position:"Query" name:"UserClientIp"`
	AzId             string `position:"Query" name:"AzId"`
	Lang             string `position:"Query" name:"Lang"`
}

// DescribeResolverAvailableZonesResponse is the response struct for api DescribeResolverAvailableZones
type DescribeResolverAvailableZonesResponse struct {
	*responses.BaseResponse
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	AvailableZones []AvailableZone `json:"AvailableZones" xml:"AvailableZones"`
}

// CreateDescribeResolverAvailableZonesRequest creates a request to invoke DescribeResolverAvailableZones API
func CreateDescribeResolverAvailableZonesRequest() (request *DescribeResolverAvailableZonesRequest) {
	request = &DescribeResolverAvailableZonesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "DescribeResolverAvailableZones", "pvtz", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeResolverAvailableZonesResponse creates a response to parse from DescribeResolverAvailableZones response
func CreateDescribeResolverAvailableZonesResponse() (response *DescribeResolverAvailableZonesResponse) {
	response = &DescribeResolverAvailableZonesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
