package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCustomLine invokes the pvtz.DeleteCustomLine API synchronously
func (client *Client) DeleteCustomLine(request *DeleteCustomLineRequest) (response *DeleteCustomLineResponse, err error) {
	response = CreateDeleteCustomLineResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCustomLineWithChan invokes the pvtz.DeleteCustomLine API asynchronously
func (client *Client) DeleteCustomLineWithChan(request *DeleteCustomLineRequest) (<-chan *DeleteCustomLineResponse, <-chan error) {
	responseChan := make(chan *DeleteCustomLineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCustomLine(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCustomLineWithCallback invokes the pvtz.DeleteCustomLine API asynchronously
func (client *Client) DeleteCustomLineWithCallback(request *DeleteCustomLineRequest, callback func(response *DeleteCustomLineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCustomLineResponse
		var err error
		defer close(result)
		response, err = client.DeleteCustomLine(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCustomLineRequest is the request struct for api DeleteCustomLine
type DeleteCustomLineRequest struct {
	*requests.RpcRequest
	LineId       string `position:"Query" name:"LineId"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DeleteCustomLineResponse is the response struct for api DeleteCustomLine
type DeleteCustomLineResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	LineId    string `json:"LineId" xml:"LineId"`
}

// CreateDeleteCustomLineRequest creates a request to invoke DeleteCustomLine API
func CreateDeleteCustomLineRequest() (request *DeleteCustomLineRequest) {
	request = &DeleteCustomLineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "DeleteCustomLine", "pvtz", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteCustomLineResponse creates a response to parse from DeleteCustomLine response
func CreateDeleteCustomLineResponse() (response *DeleteCustomLineResponse) {
	response = &DeleteCustomLineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
