package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPtsSceneRunningData invokes the pts.GetPtsSceneRunningData API synchronously
func (client *Client) GetPtsSceneRunningData(request *GetPtsSceneRunningDataRequest) (response *GetPtsSceneRunningDataResponse, err error) {
	response = CreateGetPtsSceneRunningDataResponse()
	err = client.DoAction(request, response)
	return
}

// GetPtsSceneRunningDataWithChan invokes the pts.GetPtsSceneRunningData API asynchronously
func (client *Client) GetPtsSceneRunningDataWithChan(request *GetPtsSceneRunningDataRequest) (<-chan *GetPtsSceneRunningDataResponse, <-chan error) {
	responseChan := make(chan *GetPtsSceneRunningDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPtsSceneRunningData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPtsSceneRunningDataWithCallback invokes the pts.GetPtsSceneRunningData API asynchronously
func (client *Client) GetPtsSceneRunningDataWithCallback(request *GetPtsSceneRunningDataRequest, callback func(response *GetPtsSceneRunningDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPtsSceneRunningDataResponse
		var err error
		defer close(result)
		response, err = client.GetPtsSceneRunningData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPtsSceneRunningDataRequest is the request struct for api GetPtsSceneRunningData
type GetPtsSceneRunningDataRequest struct {
	*requests.RpcRequest
	SceneId string `position:"Query" name:"SceneId"`
	PlanId  string `position:"Query" name:"PlanId"`
}

// GetPtsSceneRunningDataResponse is the response struct for api GetPtsSceneRunningData
type GetPtsSceneRunningDataResponse struct {
	*responses.BaseResponse
	Status               int                `json:"Status" xml:"Status"`
	TotalRequestCount    int64              `json:"TotalRequestCount" xml:"TotalRequestCount"`
	HasReport            bool               `json:"HasReport" xml:"HasReport"`
	ConcurrencyLimit     int                `json:"ConcurrencyLimit" xml:"ConcurrencyLimit"`
	Message              string             `json:"Message" xml:"Message"`
	RequestId            string             `json:"RequestId" xml:"RequestId"`
	BeginTime            int64              `json:"BeginTime" xml:"BeginTime"`
	Seg90Rt              int64              `json:"Seg90Rt" xml:"Seg90Rt"`
	ResponseBps          string             `json:"ResponseBps" xml:"ResponseBps"`
	TotalAgents          int                `json:"TotalAgents" xml:"TotalAgents"`
	Code                 string             `json:"Code" xml:"Code"`
	Success              bool               `json:"Success" xml:"Success"`
	Vum                  int64              `json:"Vum" xml:"Vum"`
	AverageRt            int64              `json:"AverageRt" xml:"AverageRt"`
	RequestBps           string             `json:"RequestBps" xml:"RequestBps"`
	FailedBusinessCount  int64              `json:"FailedBusinessCount" xml:"FailedBusinessCount"`
	Concurrency          int                `json:"Concurrency" xml:"Concurrency"`
	HttpStatusCode       int                `json:"HttpStatusCode" xml:"HttpStatusCode"`
	FailedRequestCount   int64              `json:"FailedRequestCount" xml:"FailedRequestCount"`
	TpsLimit             int                `json:"TpsLimit" xml:"TpsLimit"`
	AliveAgents          int                `json:"AliveAgents" xml:"AliveAgents"`
	TotalRealQps         int                `json:"TotalRealQps" xml:"TotalRealQps"`
	AgentLocation        []Location         `json:"AgentLocation" xml:"AgentLocation"`
	ChainMonitorDataList []ChainMonitorData `json:"ChainMonitorDataList" xml:"ChainMonitorDataList"`
}

// CreateGetPtsSceneRunningDataRequest creates a request to invoke GetPtsSceneRunningData API
func CreateGetPtsSceneRunningDataRequest() (request *GetPtsSceneRunningDataRequest) {
	request = &GetPtsSceneRunningDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "GetPtsSceneRunningData", "", "")
	request.Method = requests.POST
	return
}

// CreateGetPtsSceneRunningDataResponse creates a response to parse from GetPtsSceneRunningData response
func CreateGetPtsSceneRunningDataResponse() (response *GetPtsSceneRunningDataResponse) {
	response = &GetPtsSceneRunningDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
