package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckProductOpen invokes the privatelink.CheckProductOpen API synchronously
func (client *Client) CheckProductOpen(request *CheckProductOpenRequest) (response *CheckProductOpenResponse, err error) {
	response = CreateCheckProductOpenResponse()
	err = client.DoAction(request, response)
	return
}

// CheckProductOpenWithChan invokes the privatelink.CheckProductOpen API asynchronously
func (client *Client) CheckProductOpenWithChan(request *CheckProductOpenRequest) (<-chan *CheckProductOpenResponse, <-chan error) {
	responseChan := make(chan *CheckProductOpenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckProductOpen(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckProductOpenWithCallback invokes the privatelink.CheckProductOpen API asynchronously
func (client *Client) CheckProductOpenWithCallback(request *CheckProductOpenRequest, callback func(response *CheckProductOpenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckProductOpenResponse
		var err error
		defer close(result)
		response, err = client.CheckProductOpen(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckProductOpenRequest is the request struct for api CheckProductOpen
type CheckProductOpenRequest struct {
	*requests.RpcRequest
}

// CheckProductOpenResponse is the response struct for api CheckProductOpen
type CheckProductOpenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCheckProductOpenRequest creates a request to invoke CheckProductOpen API
func CreateCheckProductOpenRequest() (request *CheckProductOpenRequest) {
	request = &CheckProductOpenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "CheckProductOpen", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckProductOpenResponse creates a response to parse from CheckProductOpen response
func CreateCheckProductOpenResponse() (response *CheckProductOpenResponse) {
	response = &CheckProductOpenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
