package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OnlineExperimentGroup invokes the pairecservice.OnlineExperimentGroup API synchronously
func (client *Client) OnlineExperimentGroup(request *OnlineExperimentGroupRequest) (response *OnlineExperimentGroupResponse, err error) {
	response = CreateOnlineExperimentGroupResponse()
	err = client.DoAction(request, response)
	return
}

// OnlineExperimentGroupWithChan invokes the pairecservice.OnlineExperimentGroup API asynchronously
func (client *Client) OnlineExperimentGroupWithChan(request *OnlineExperimentGroupRequest) (<-chan *OnlineExperimentGroupResponse, <-chan error) {
	responseChan := make(chan *OnlineExperimentGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OnlineExperimentGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OnlineExperimentGroupWithCallback invokes the pairecservice.OnlineExperimentGroup API asynchronously
func (client *Client) OnlineExperimentGroupWithCallback(request *OnlineExperimentGroupRequest, callback func(response *OnlineExperimentGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OnlineExperimentGroupResponse
		var err error
		defer close(result)
		response, err = client.OnlineExperimentGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OnlineExperimentGroupRequest is the request struct for api OnlineExperimentGroup
type OnlineExperimentGroupRequest struct {
	*requests.RoaRequest
	Body              string `position:"Body" name:"body"`
	ExperimentGroupId string `position:"Path" name:"ExperimentGroupId"`
}

// OnlineExperimentGroupResponse is the response struct for api OnlineExperimentGroup
type OnlineExperimentGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOnlineExperimentGroupRequest creates a request to invoke OnlineExperimentGroup API
func CreateOnlineExperimentGroupRequest() (request *OnlineExperimentGroupRequest) {
	request = &OnlineExperimentGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "OnlineExperimentGroup", "/api/v1/experimentgroups/[ExperimentGroupId]/action/online", "", "")
	request.Method = requests.POST
	return
}

// CreateOnlineExperimentGroupResponse creates a response to parse from OnlineExperimentGroup response
func CreateOnlineExperimentGroupResponse() (response *OnlineExperimentGroupResponse) {
	response = &OnlineExperimentGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
