package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTrafficControlTasks invokes the pairecservice.ListTrafficControlTasks API synchronously
func (client *Client) ListTrafficControlTasks(request *ListTrafficControlTasksRequest) (response *ListTrafficControlTasksResponse, err error) {
	response = CreateListTrafficControlTasksResponse()
	err = client.DoAction(request, response)
	return
}

// ListTrafficControlTasksWithChan invokes the pairecservice.ListTrafficControlTasks API asynchronously
func (client *Client) ListTrafficControlTasksWithChan(request *ListTrafficControlTasksRequest) (<-chan *ListTrafficControlTasksResponse, <-chan error) {
	responseChan := make(chan *ListTrafficControlTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTrafficControlTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTrafficControlTasksWithCallback invokes the pairecservice.ListTrafficControlTasks API asynchronously
func (client *Client) ListTrafficControlTasksWithCallback(request *ListTrafficControlTasksRequest, callback func(response *ListTrafficControlTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTrafficControlTasksResponse
		var err error
		defer close(result)
		response, err = client.ListTrafficControlTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTrafficControlTasksRequest is the request struct for api ListTrafficControlTasks
type ListTrafficControlTasksRequest struct {
	*requests.RoaRequest
	PageNumber           string           `position:"Query" name:"PageNumber"`
	ControlTargetFilter  string           `position:"Query" name:"ControlTargetFilter"`
	PageSize             string           `position:"Query" name:"PageSize"`
	Order                string           `position:"Query" name:"Order"`
	All                  requests.Boolean `position:"Query" name:"All"`
	TrafficControlTaskId string           `position:"Query" name:"TrafficControlTaskId"`
	Version              string           `position:"Query" name:"Version"`
	Environment          string           `position:"Query" name:"Environment"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	Name                 string           `position:"Query" name:"Name"`
	SceneId              string           `position:"Query" name:"SceneId"`
	SortBy               string           `position:"Query" name:"SortBy"`
	Status               string           `position:"Query" name:"Status"`
}

// ListTrafficControlTasksResponse is the response struct for api ListTrafficControlTasks
type ListTrafficControlTasksResponse struct {
	*responses.BaseResponse
	RequestId           string                    `json:"RequestId" xml:"RequestId"`
	TotalCount          string                    `json:"TotalCount" xml:"TotalCount"`
	TrafficControlTasks []TrafficControlTasksItem `json:"TrafficControlTasks" xml:"TrafficControlTasks"`
}

// CreateListTrafficControlTasksRequest creates a request to invoke ListTrafficControlTasks API
func CreateListTrafficControlTasksRequest() (request *ListTrafficControlTasksRequest) {
	request = &ListTrafficControlTasksRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ListTrafficControlTasks", "/api/v1/trafficcontroltasks", "", "")
	request.Method = requests.GET
	return
}

// CreateListTrafficControlTasksResponse creates a response to parse from ListTrafficControlTasks response
func CreateListTrafficControlTasksResponse() (response *ListTrafficControlTasksResponse) {
	response = &ListTrafficControlTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
