package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListResourceRules invokes the pairecservice.ListResourceRules API synchronously
func (client *Client) ListResourceRules(request *ListResourceRulesRequest) (response *ListResourceRulesResponse, err error) {
	response = CreateListResourceRulesResponse()
	err = client.DoAction(request, response)
	return
}

// ListResourceRulesWithChan invokes the pairecservice.ListResourceRules API asynchronously
func (client *Client) ListResourceRulesWithChan(request *ListResourceRulesRequest) (<-chan *ListResourceRulesResponse, <-chan error) {
	responseChan := make(chan *ListResourceRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListResourceRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListResourceRulesWithCallback invokes the pairecservice.ListResourceRules API asynchronously
func (client *Client) ListResourceRulesWithCallback(request *ListResourceRulesRequest, callback func(response *ListResourceRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListResourceRulesResponse
		var err error
		defer close(result)
		response, err = client.ListResourceRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListResourceRulesRequest is the request struct for api ListResourceRules
type ListResourceRulesRequest struct {
	*requests.RoaRequest
	All              requests.Boolean `position:"Query" name:"All"`
	ResourceRuleName string           `position:"Query" name:"ResourceRuleName"`
	ResourceRuleId   string           `position:"Query" name:"ResourceRuleId"`
	PageNumber       requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId       string           `position:"Query" name:"InstanceId"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	SortBy           string           `position:"Query" name:"SortBy"`
	Order            string           `position:"Query" name:"Order"`
}

// ListResourceRulesResponse is the response struct for api ListResourceRules
type ListResourceRulesResponse struct {
	*responses.BaseResponse
	RequestId     string              `json:"RequestId" xml:"RequestId"`
	TotalCount    int64               `json:"TotalCount" xml:"TotalCount"`
	ResourceRules []ResourceRulesItem `json:"ResourceRules" xml:"ResourceRules"`
}

// CreateListResourceRulesRequest creates a request to invoke ListResourceRules API
func CreateListResourceRulesRequest() (request *ListResourceRulesRequest) {
	request = &ListResourceRulesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ListResourceRules", "/api/v1/resourcerules", "", "")
	request.Method = requests.GET
	return
}

// CreateListResourceRulesResponse creates a response to parse from ListResourceRules response
func CreateListResourceRulesResponse() (response *ListResourceRulesResponse) {
	response = &ListResourceRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
