package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListParams invokes the pairecservice.ListParams API synchronously
func (client *Client) ListParams(request *ListParamsRequest) (response *ListParamsResponse, err error) {
	response = CreateListParamsResponse()
	err = client.DoAction(request, response)
	return
}

// ListParamsWithChan invokes the pairecservice.ListParams API asynchronously
func (client *Client) ListParamsWithChan(request *ListParamsRequest) (<-chan *ListParamsResponse, <-chan error) {
	responseChan := make(chan *ListParamsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListParams(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListParamsWithCallback invokes the pairecservice.ListParams API asynchronously
func (client *Client) ListParamsWithCallback(request *ListParamsRequest, callback func(response *ListParamsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListParamsResponse
		var err error
		defer close(result)
		response, err = client.ListParams(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListParamsRequest is the request struct for api ListParams
type ListParamsRequest struct {
	*requests.RoaRequest
	Environment string           `position:"Query" name:"Environment"`
	InstanceId  string           `position:"Query" name:"InstanceId"`
	SceneId     string           `position:"Query" name:"SceneId"`
	Name        string           `position:"Query" name:"Name"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
}

// ListParamsResponse is the response struct for api ListParams
type ListParamsResponse struct {
	*responses.BaseResponse
	RequestId  string       `json:"RequestId" xml:"RequestId"`
	TotalCount int64        `json:"TotalCount" xml:"TotalCount"`
	Params     []ParamsItem `json:"Params" xml:"Params"`
}

// CreateListParamsRequest creates a request to invoke ListParams API
func CreateListParamsRequest() (request *ListParamsRequest) {
	request = &ListParamsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ListParams", "/api/v1/params", "", "")
	request.Method = requests.GET
	return
}

// CreateListParamsResponse creates a response to parse from ListParams response
func CreateListParamsResponse() (response *ListParamsResponse) {
	response = &ListParamsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
