package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCalculationJob invokes the pairecservice.GetCalculationJob API synchronously
func (client *Client) GetCalculationJob(request *GetCalculationJobRequest) (response *GetCalculationJobResponse, err error) {
	response = CreateGetCalculationJobResponse()
	err = client.DoAction(request, response)
	return
}

// GetCalculationJobWithChan invokes the pairecservice.GetCalculationJob API asynchronously
func (client *Client) GetCalculationJobWithChan(request *GetCalculationJobRequest) (<-chan *GetCalculationJobResponse, <-chan error) {
	responseChan := make(chan *GetCalculationJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCalculationJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCalculationJobWithCallback invokes the pairecservice.GetCalculationJob API asynchronously
func (client *Client) GetCalculationJobWithCallback(request *GetCalculationJobRequest, callback func(response *GetCalculationJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCalculationJobResponse
		var err error
		defer close(result)
		response, err = client.GetCalculationJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCalculationJobRequest is the request struct for api GetCalculationJob
type GetCalculationJobRequest struct {
	*requests.RoaRequest
	InstanceId       string `position:"Query" name:"InstanceId"`
	CalculationJobId string `position:"Path" name:"CalculationJobId"`
}

// GetCalculationJobResponse is the response struct for api GetCalculationJob
type GetCalculationJobResponse struct {
	*responses.BaseResponse
	RequestId    string   `json:"RequestId" xml:"RequestId"`
	ABMetricId   string   `json:"ABMetricId" xml:"ABMetricId"`
	ABMetricName string   `json:"ABMetricName" xml:"ABMetricName"`
	Status       string   `json:"Status" xml:"Status"`
	Config       string   `json:"Config" xml:"Config"`
	GmtRanTime   string   `json:"GmtRanTime" xml:"GmtRanTime"`
	BizDate      string   `json:"BizDate" xml:"BizDate"`
	JobSource    string   `json:"JobSource" xml:"JobSource"`
	JobMessage   []string `json:"JobMessage" xml:"JobMessage"`
}

// CreateGetCalculationJobRequest creates a request to invoke GetCalculationJob API
func CreateGetCalculationJobRequest() (request *GetCalculationJobRequest) {
	request = &GetCalculationJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "GetCalculationJob", "/api/v1/calculationjobs/[CalculationJobId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetCalculationJobResponse creates a response to parse from GetCalculationJob response
func CreateGetCalculationJobResponse() (response *GetCalculationJobResponse) {
	response = &GetCalculationJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
