package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateResourceRule invokes the pairecservice.CreateResourceRule API synchronously
func (client *Client) CreateResourceRule(request *CreateResourceRuleRequest) (response *CreateResourceRuleResponse, err error) {
	response = CreateCreateResourceRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateResourceRuleWithChan invokes the pairecservice.CreateResourceRule API asynchronously
func (client *Client) CreateResourceRuleWithChan(request *CreateResourceRuleRequest) (<-chan *CreateResourceRuleResponse, <-chan error) {
	responseChan := make(chan *CreateResourceRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateResourceRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateResourceRuleWithCallback invokes the pairecservice.CreateResourceRule API asynchronously
func (client *Client) CreateResourceRuleWithCallback(request *CreateResourceRuleRequest, callback func(response *CreateResourceRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateResourceRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateResourceRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateResourceRuleRequest is the request struct for api CreateResourceRule
type CreateResourceRuleRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// CreateResourceRuleResponse is the response struct for api CreateResourceRule
type CreateResourceRuleResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ResourceRuleId string `json:"ResourceRuleId" xml:"ResourceRuleId"`
}

// CreateCreateResourceRuleRequest creates a request to invoke CreateResourceRule API
func CreateCreateResourceRuleRequest() (request *CreateResourceRuleRequest) {
	request = &CreateResourceRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "CreateResourceRule", "/api/v1/resourcerules", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateResourceRuleResponse creates a response to parse from CreateResourceRule response
func CreateCreateResourceRuleResponse() (response *CreateResourceRuleResponse) {
	response = &CreateResourceRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
