package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloneFeatureConsistencyCheckJobConfig invokes the pairecservice.CloneFeatureConsistencyCheckJobConfig API synchronously
func (client *Client) CloneFeatureConsistencyCheckJobConfig(request *CloneFeatureConsistencyCheckJobConfigRequest) (response *CloneFeatureConsistencyCheckJobConfigResponse, err error) {
	response = CreateCloneFeatureConsistencyCheckJobConfigResponse()
	err = client.DoAction(request, response)
	return
}

// CloneFeatureConsistencyCheckJobConfigWithChan invokes the pairecservice.CloneFeatureConsistencyCheckJobConfig API asynchronously
func (client *Client) CloneFeatureConsistencyCheckJobConfigWithChan(request *CloneFeatureConsistencyCheckJobConfigRequest) (<-chan *CloneFeatureConsistencyCheckJobConfigResponse, <-chan error) {
	responseChan := make(chan *CloneFeatureConsistencyCheckJobConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloneFeatureConsistencyCheckJobConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloneFeatureConsistencyCheckJobConfigWithCallback invokes the pairecservice.CloneFeatureConsistencyCheckJobConfig API asynchronously
func (client *Client) CloneFeatureConsistencyCheckJobConfigWithCallback(request *CloneFeatureConsistencyCheckJobConfigRequest, callback func(response *CloneFeatureConsistencyCheckJobConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloneFeatureConsistencyCheckJobConfigResponse
		var err error
		defer close(result)
		response, err = client.CloneFeatureConsistencyCheckJobConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloneFeatureConsistencyCheckJobConfigRequest is the request struct for api CloneFeatureConsistencyCheckJobConfig
type CloneFeatureConsistencyCheckJobConfigRequest struct {
	*requests.RoaRequest
	Body                                     string `position:"Body" name:"body"`
	SourceFeatureConsistencyCheckJobConfigId string `position:"Path" name:"SourceFeatureConsistencyCheckJobConfigId"`
}

// CloneFeatureConsistencyCheckJobConfigResponse is the response struct for api CloneFeatureConsistencyCheckJobConfig
type CloneFeatureConsistencyCheckJobConfigResponse struct {
	*responses.BaseResponse
	RequestId                 string `json:"RequestId" xml:"RequestId"`
	FeatureConsistencyCheckId string `json:"FeatureConsistencyCheckId" xml:"FeatureConsistencyCheckId"`
}

// CreateCloneFeatureConsistencyCheckJobConfigRequest creates a request to invoke CloneFeatureConsistencyCheckJobConfig API
func CreateCloneFeatureConsistencyCheckJobConfigRequest() (request *CloneFeatureConsistencyCheckJobConfigRequest) {
	request = &CloneFeatureConsistencyCheckJobConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "CloneFeatureConsistencyCheckJobConfig", "/api/v1/featureconsistencycheck/jobconfigs/[SourceFeatureConsistencyCheckJobConfigId]/action/clone", "", "")
	request.Method = requests.POST
	return
}

// CreateCloneFeatureConsistencyCheckJobConfigResponse creates a response to parse from CloneFeatureConsistencyCheckJobConfig response
func CreateCloneFeatureConsistencyCheckJobConfigResponse() (response *CloneFeatureConsistencyCheckJobConfigResponse) {
	response = &CloneFeatureConsistencyCheckJobConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
