package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateServiceIdentityRole invokes the paifeaturestore.CreateServiceIdentityRole API synchronously
func (client *Client) CreateServiceIdentityRole(request *CreateServiceIdentityRoleRequest) (response *CreateServiceIdentityRoleResponse, err error) {
	response = CreateCreateServiceIdentityRoleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateServiceIdentityRoleWithChan invokes the paifeaturestore.CreateServiceIdentityRole API asynchronously
func (client *Client) CreateServiceIdentityRoleWithChan(request *CreateServiceIdentityRoleRequest) (<-chan *CreateServiceIdentityRoleResponse, <-chan error) {
	responseChan := make(chan *CreateServiceIdentityRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateServiceIdentityRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateServiceIdentityRoleWithCallback invokes the paifeaturestore.CreateServiceIdentityRole API asynchronously
func (client *Client) CreateServiceIdentityRoleWithCallback(request *CreateServiceIdentityRoleRequest, callback func(response *CreateServiceIdentityRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateServiceIdentityRoleResponse
		var err error
		defer close(result)
		response, err = client.CreateServiceIdentityRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateServiceIdentityRoleRequest is the request struct for api CreateServiceIdentityRole
type CreateServiceIdentityRoleRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// CreateServiceIdentityRoleResponse is the response struct for api CreateServiceIdentityRole
type CreateServiceIdentityRoleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	RoleName  string `json:"RoleName" xml:"RoleName"`
	Code      string `json:"Code" xml:"Code"`
}

// CreateCreateServiceIdentityRoleRequest creates a request to invoke CreateServiceIdentityRole API
func CreateCreateServiceIdentityRoleRequest() (request *CreateServiceIdentityRoleRequest) {
	request = &CreateServiceIdentityRoleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "CreateServiceIdentityRole", "/api/v1/serviceidentityroles", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateServiceIdentityRoleResponse creates a response to parse from CreateServiceIdentityRole response
func CreateCreateServiceIdentityRoleResponse() (response *CreateServiceIdentityRoleResponse) {
	response = &CreateServiceIdentityRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
