package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDatasource invokes the paifeaturestore.CreateDatasource API synchronously
func (client *Client) CreateDatasource(request *CreateDatasourceRequest) (response *CreateDatasourceResponse, err error) {
	response = CreateCreateDatasourceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDatasourceWithChan invokes the paifeaturestore.CreateDatasource API asynchronously
func (client *Client) CreateDatasourceWithChan(request *CreateDatasourceRequest) (<-chan *CreateDatasourceResponse, <-chan error) {
	responseChan := make(chan *CreateDatasourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDatasource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDatasourceWithCallback invokes the paifeaturestore.CreateDatasource API asynchronously
func (client *Client) CreateDatasourceWithCallback(request *CreateDatasourceRequest, callback func(response *CreateDatasourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDatasourceResponse
		var err error
		defer close(result)
		response, err = client.CreateDatasource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDatasourceRequest is the request struct for api CreateDatasource
type CreateDatasourceRequest struct {
	*requests.RoaRequest
	Body       string `position:"Body" name:"body"`
	InstanceId string `position:"Path" name:"InstanceId"`
}

// CreateDatasourceResponse is the response struct for api CreateDatasource
type CreateDatasourceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	DatasourceId string `json:"DatasourceId" xml:"DatasourceId"`
}

// CreateCreateDatasourceRequest creates a request to invoke CreateDatasource API
func CreateCreateDatasourceRequest() (request *CreateDatasourceRequest) {
	request = &CreateDatasourceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "CreateDatasource", "/api/v1/instances/[InstanceId]/datasources", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDatasourceResponse creates a response to parse from CreateDatasource response
func CreateCreateDatasourceResponse() (response *CreateDatasourceResponse) {
	response = &CreateDatasourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
