package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateJobDataParsingTask invokes the outboundbot.CreateJobDataParsingTask API synchronously
func (client *Client) CreateJobDataParsingTask(request *CreateJobDataParsingTaskRequest) (response *CreateJobDataParsingTaskResponse, err error) {
	response = CreateCreateJobDataParsingTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateJobDataParsingTaskWithChan invokes the outboundbot.CreateJobDataParsingTask API asynchronously
func (client *Client) CreateJobDataParsingTaskWithChan(request *CreateJobDataParsingTaskRequest) (<-chan *CreateJobDataParsingTaskResponse, <-chan error) {
	responseChan := make(chan *CreateJobDataParsingTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateJobDataParsingTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateJobDataParsingTaskWithCallback invokes the outboundbot.CreateJobDataParsingTask API asynchronously
func (client *Client) CreateJobDataParsingTaskWithCallback(request *CreateJobDataParsingTaskRequest, callback func(response *CreateJobDataParsingTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateJobDataParsingTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateJobDataParsingTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateJobDataParsingTaskRequest is the request struct for api CreateJobDataParsingTask
type CreateJobDataParsingTaskRequest struct {
	*requests.RpcRequest
	JobFilePath string `position:"Query" name:"JobFilePath"`
	InstanceId  string `position:"Query" name:"InstanceId"`
}

// CreateJobDataParsingTaskResponse is the response struct for api CreateJobDataParsingTask
type CreateJobDataParsingTaskResponse struct {
	*responses.BaseResponse
	HttpStatusCode       int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId            string `json:"RequestId" xml:"RequestId"`
	Success              bool   `json:"Success" xml:"Success"`
	Code                 string `json:"Code" xml:"Code"`
	Message              string `json:"Message" xml:"Message"`
	JobDataParsingTaskId string `json:"JobDataParsingTaskId" xml:"JobDataParsingTaskId"`
}

// CreateCreateJobDataParsingTaskRequest creates a request to invoke CreateJobDataParsingTask API
func CreateCreateJobDataParsingTaskRequest() (request *CreateJobDataParsingTaskRequest) {
	request = &CreateJobDataParsingTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "CreateJobDataParsingTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateJobDataParsingTaskResponse creates a response to parse from CreateJobDataParsingTask response
func CreateCreateJobDataParsingTaskResponse() (response *CreateJobDataParsingTaskResponse) {
	response = &CreateJobDataParsingTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
