package onsmqtt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefreshDeviceCredential invokes the onsmqtt.RefreshDeviceCredential API synchronously
func (client *Client) RefreshDeviceCredential(request *RefreshDeviceCredentialRequest) (response *RefreshDeviceCredentialResponse, err error) {
	response = CreateRefreshDeviceCredentialResponse()
	err = client.DoAction(request, response)
	return
}

// RefreshDeviceCredentialWithChan invokes the onsmqtt.RefreshDeviceCredential API asynchronously
func (client *Client) RefreshDeviceCredentialWithChan(request *RefreshDeviceCredentialRequest) (<-chan *RefreshDeviceCredentialResponse, <-chan error) {
	responseChan := make(chan *RefreshDeviceCredentialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefreshDeviceCredential(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefreshDeviceCredentialWithCallback invokes the onsmqtt.RefreshDeviceCredential API asynchronously
func (client *Client) RefreshDeviceCredentialWithCallback(request *RefreshDeviceCredentialRequest, callback func(response *RefreshDeviceCredentialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefreshDeviceCredentialResponse
		var err error
		defer close(result)
		response, err = client.RefreshDeviceCredential(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefreshDeviceCredentialRequest is the request struct for api RefreshDeviceCredential
type RefreshDeviceCredentialRequest struct {
	*requests.RpcRequest
	ClientId   string `position:"Query" name:"ClientId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// RefreshDeviceCredentialResponse is the response struct for api RefreshDeviceCredential
type RefreshDeviceCredentialResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	DeviceCredential DeviceCredential `json:"DeviceCredential" xml:"DeviceCredential"`
}

// CreateRefreshDeviceCredentialRequest creates a request to invoke RefreshDeviceCredential API
func CreateRefreshDeviceCredentialRequest() (request *RefreshDeviceCredentialRequest) {
	request = &RefreshDeviceCredentialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OnsMqtt", "2020-04-20", "RefreshDeviceCredential", "onsmqtt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRefreshDeviceCredentialResponse creates a response to parse from RefreshDeviceCredential response
func CreateRefreshDeviceCredentialResponse() (response *RefreshDeviceCredentialResponse) {
	response = &RefreshDeviceCredentialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
