package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopProjectsByLabel invokes the oceanbasepro.StopProjectsByLabel API synchronously
func (client *Client) StopProjectsByLabel(request *StopProjectsByLabelRequest) (response *StopProjectsByLabelResponse, err error) {
	response = CreateStopProjectsByLabelResponse()
	err = client.DoAction(request, response)
	return
}

// StopProjectsByLabelWithChan invokes the oceanbasepro.StopProjectsByLabel API asynchronously
func (client *Client) StopProjectsByLabelWithChan(request *StopProjectsByLabelRequest) (<-chan *StopProjectsByLabelResponse, <-chan error) {
	responseChan := make(chan *StopProjectsByLabelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopProjectsByLabel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopProjectsByLabelWithCallback invokes the oceanbasepro.StopProjectsByLabel API asynchronously
func (client *Client) StopProjectsByLabelWithCallback(request *StopProjectsByLabelRequest, callback func(response *StopProjectsByLabelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopProjectsByLabelResponse
		var err error
		defer close(result)
		response, err = client.StopProjectsByLabel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopProjectsByLabelRequest is the request struct for api StopProjectsByLabel
type StopProjectsByLabelRequest struct {
	*requests.RpcRequest
	Id string `position:"Body" name:"Id"`
}

// StopProjectsByLabelResponse is the response struct for api StopProjectsByLabel
type StopProjectsByLabelResponse struct {
	*responses.BaseResponse
}

// CreateStopProjectsByLabelRequest creates a request to invoke StopProjectsByLabel API
func CreateStopProjectsByLabelRequest() (request *StopProjectsByLabelRequest) {
	request = &StopProjectsByLabelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "StopProjectsByLabel", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopProjectsByLabelResponse creates a response to parse from StopProjectsByLabel response
func CreateStopProjectsByLabelResponse() (response *StopProjectsByLabelResponse) {
	response = &StopProjectsByLabelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
