package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTenantSecurityIpGroup invokes the oceanbasepro.ModifyTenantSecurityIpGroup API synchronously
func (client *Client) ModifyTenantSecurityIpGroup(request *ModifyTenantSecurityIpGroupRequest) (response *ModifyTenantSecurityIpGroupResponse, err error) {
	response = CreateModifyTenantSecurityIpGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTenantSecurityIpGroupWithChan invokes the oceanbasepro.ModifyTenantSecurityIpGroup API asynchronously
func (client *Client) ModifyTenantSecurityIpGroupWithChan(request *ModifyTenantSecurityIpGroupRequest) (<-chan *ModifyTenantSecurityIpGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyTenantSecurityIpGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTenantSecurityIpGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTenantSecurityIpGroupWithCallback invokes the oceanbasepro.ModifyTenantSecurityIpGroup API asynchronously
func (client *Client) ModifyTenantSecurityIpGroupWithCallback(request *ModifyTenantSecurityIpGroupRequest, callback func(response *ModifyTenantSecurityIpGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTenantSecurityIpGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyTenantSecurityIpGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTenantSecurityIpGroupRequest is the request struct for api ModifyTenantSecurityIpGroup
type ModifyTenantSecurityIpGroupRequest struct {
	*requests.RpcRequest
	SecurityIps         string `position:"Body" name:"SecurityIps"`
	SecurityIpGroupName string `position:"Body" name:"SecurityIpGroupName"`
	InstanceId          string `position:"Body" name:"InstanceId"`
	TenantId            string `position:"Body" name:"TenantId"`
}

// ModifyTenantSecurityIpGroupResponse is the response struct for api ModifyTenantSecurityIpGroup
type ModifyTenantSecurityIpGroupResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	SecurityIpGroup SecurityIpGroup `json:"SecurityIpGroup" xml:"SecurityIpGroup"`
}

// CreateModifyTenantSecurityIpGroupRequest creates a request to invoke ModifyTenantSecurityIpGroup API
func CreateModifyTenantSecurityIpGroupRequest() (request *ModifyTenantSecurityIpGroupRequest) {
	request = &ModifyTenantSecurityIpGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "ModifyTenantSecurityIpGroup", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyTenantSecurityIpGroupResponse creates a response to parse from ModifyTenantSecurityIpGroup response
func CreateModifyTenantSecurityIpGroupResponse() (response *ModifyTenantSecurityIpGroupResponse) {
	response = &ModifyTenantSecurityIpGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
