package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOasSQLDetails invokes the oceanbasepro.DescribeOasSQLDetails API synchronously
func (client *Client) DescribeOasSQLDetails(request *DescribeOasSQLDetailsRequest) (response *DescribeOasSQLDetailsResponse, err error) {
	response = CreateDescribeOasSQLDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOasSQLDetailsWithChan invokes the oceanbasepro.DescribeOasSQLDetails API asynchronously
func (client *Client) DescribeOasSQLDetailsWithChan(request *DescribeOasSQLDetailsRequest) (<-chan *DescribeOasSQLDetailsResponse, <-chan error) {
	responseChan := make(chan *DescribeOasSQLDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOasSQLDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOasSQLDetailsWithCallback invokes the oceanbasepro.DescribeOasSQLDetails API asynchronously
func (client *Client) DescribeOasSQLDetailsWithCallback(request *DescribeOasSQLDetailsRequest, callback func(response *DescribeOasSQLDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOasSQLDetailsResponse
		var err error
		defer close(result)
		response, err = client.DescribeOasSQLDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOasSQLDetailsRequest is the request struct for api DescribeOasSQLDetails
type DescribeOasSQLDetailsRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Body" name:"StartTime"`
	ParseTable requests.Boolean `position:"Body" name:"ParseTable"`
	DynamicSql requests.Boolean `position:"Body" name:"DynamicSql"`
	TenantId   string           `position:"Body" name:"TenantId"`
	SqlId      string           `position:"Body" name:"SqlId"`
	EndTime    string           `position:"Body" name:"EndTime"`
	InstanceId string           `position:"Body" name:"InstanceId"`
	DbName     string           `position:"Body" name:"DbName"`
}

// DescribeOasSQLDetailsResponse is the response struct for api DescribeOasSQLDetails
type DescribeOasSQLDetailsResponse struct {
	*responses.BaseResponse
	RequestId string                      `json:"RequestId" xml:"RequestId"`
	Data      DataInDescribeOasSQLDetails `json:"Data" xml:"Data"`
}

// CreateDescribeOasSQLDetailsRequest creates a request to invoke DescribeOasSQLDetails API
func CreateDescribeOasSQLDetailsRequest() (request *DescribeOasSQLDetailsRequest) {
	request = &DescribeOasSQLDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeOasSQLDetails", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeOasSQLDetailsResponse creates a response to parse from DescribeOasSQLDetails response
func CreateDescribeOasSQLDetailsResponse() (response *DescribeOasSQLDetailsResponse) {
	response = &DescribeOasSQLDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
