package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDatabases invokes the oceanbasepro.DeleteDatabases API synchronously
func (client *Client) DeleteDatabases(request *DeleteDatabasesRequest) (response *DeleteDatabasesResponse, err error) {
	response = CreateDeleteDatabasesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDatabasesWithChan invokes the oceanbasepro.DeleteDatabases API asynchronously
func (client *Client) DeleteDatabasesWithChan(request *DeleteDatabasesRequest) (<-chan *DeleteDatabasesResponse, <-chan error) {
	responseChan := make(chan *DeleteDatabasesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDatabases(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDatabasesWithCallback invokes the oceanbasepro.DeleteDatabases API asynchronously
func (client *Client) DeleteDatabasesWithCallback(request *DeleteDatabasesRequest, callback func(response *DeleteDatabasesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDatabasesResponse
		var err error
		defer close(result)
		response, err = client.DeleteDatabases(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDatabasesRequest is the request struct for api DeleteDatabases
type DeleteDatabasesRequest struct {
	*requests.RpcRequest
	InstanceId    string `position:"Body" name:"InstanceId"`
	DatabaseNames string `position:"Body" name:"DatabaseNames"`
	TenantId      string `position:"Body" name:"TenantId"`
}

// DeleteDatabasesResponse is the response struct for api DeleteDatabases
type DeleteDatabasesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDatabasesRequest creates a request to invoke DeleteDatabases API
func CreateDeleteDatabasesRequest() (request *DeleteDatabasesRequest) {
	request = &DeleteDatabasesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DeleteDatabases", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDatabasesResponse creates a response to parse from DeleteDatabases response
func CreateDeleteDatabasesResponse() (response *DeleteDatabasesResponse) {
	response = &DeleteDatabasesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
