package nlp_automl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FindUserReport4Alinlp invokes the nlp_automl.FindUserReport4Alinlp API synchronously
func (client *Client) FindUserReport4Alinlp(request *FindUserReport4AlinlpRequest) (response *FindUserReport4AlinlpResponse, err error) {
	response = CreateFindUserReport4AlinlpResponse()
	err = client.DoAction(request, response)
	return
}

// FindUserReport4AlinlpWithChan invokes the nlp_automl.FindUserReport4Alinlp API asynchronously
func (client *Client) FindUserReport4AlinlpWithChan(request *FindUserReport4AlinlpRequest) (<-chan *FindUserReport4AlinlpResponse, <-chan error) {
	responseChan := make(chan *FindUserReport4AlinlpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FindUserReport4Alinlp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FindUserReport4AlinlpWithCallback invokes the nlp_automl.FindUserReport4Alinlp API asynchronously
func (client *Client) FindUserReport4AlinlpWithCallback(request *FindUserReport4AlinlpRequest, callback func(response *FindUserReport4AlinlpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FindUserReport4AlinlpResponse
		var err error
		defer close(result)
		response, err = client.FindUserReport4Alinlp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FindUserReport4AlinlpRequest is the request struct for api FindUserReport4Alinlp
type FindUserReport4AlinlpRequest struct {
	*requests.RpcRequest
	CustomerUserParentId requests.Integer `position:"Body" name:"CustomerUserParentId"`
	EndTime              string           `position:"Body" name:"EndTime"`
	BeginTime            string           `position:"Body" name:"BeginTime"`
	Type                 string           `position:"Body" name:"Type"`
	ModelType            string           `position:"Body" name:"ModelType"`
}

// FindUserReport4AlinlpResponse is the response struct for api FindUserReport4Alinlp
type FindUserReport4AlinlpResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Code      string   `json:"Code" xml:"Code"`
	Data      []Report `json:"Data" xml:"Data"`
}

// CreateFindUserReport4AlinlpRequest creates a request to invoke FindUserReport4Alinlp API
func CreateFindUserReport4AlinlpRequest() (request *FindUserReport4AlinlpRequest) {
	request = &FindUserReport4AlinlpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nlp-automl", "2019-11-11", "FindUserReport4Alinlp", "", "")
	request.Method = requests.POST
	return
}

// CreateFindUserReport4AlinlpResponse creates a response to parse from FindUserReport4Alinlp response
func CreateFindUserReport4AlinlpResponse() (response *FindUserReport4AlinlpResponse) {
	response = &FindUserReport4AlinlpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
