package netana

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNetworkQuotaRequest invokes the netana.CreateNetworkQuotaRequest API synchronously
// api document: https://help.aliyun.com/api/netana/createnetworkquotarequest.html
func (client *Client) CreateNetworkQuotaRequest(request *CreateNetworkQuotaRequestRequest) (response *CreateNetworkQuotaRequestResponse, err error) {
	response = CreateCreateNetworkQuotaRequestResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNetworkQuotaRequestWithChan invokes the netana.CreateNetworkQuotaRequest API asynchronously
// api document: https://help.aliyun.com/api/netana/createnetworkquotarequest.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateNetworkQuotaRequestWithChan(request *CreateNetworkQuotaRequestRequest) (<-chan *CreateNetworkQuotaRequestResponse, <-chan error) {
	responseChan := make(chan *CreateNetworkQuotaRequestResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNetworkQuotaRequest(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNetworkQuotaRequestWithCallback invokes the netana.CreateNetworkQuotaRequest API asynchronously
// api document: https://help.aliyun.com/api/netana/createnetworkquotarequest.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateNetworkQuotaRequestWithCallback(request *CreateNetworkQuotaRequestRequest, callback func(response *CreateNetworkQuotaRequestResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNetworkQuotaRequestResponse
		var err error
		defer close(result)
		response, err = client.CreateNetworkQuotaRequest(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNetworkQuotaRequestRequest is the request struct for api CreateNetworkQuotaRequest
type CreateNetworkQuotaRequestRequest struct {
	*requests.RpcRequest
	RequestReason        string           `position:"Query" name:"RequestReason"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Product              string           `position:"Query" name:"Product"`
	QuotaPublicityName   string           `position:"Query" name:"QuotaPublicityName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	RequestQuantity      string           `position:"Query" name:"RequestQuantity"`
	MobilePhone          string           `position:"Query" name:"MobilePhone"`
	ResourceType         string           `position:"Query" name:"ResourceType"`
	Email                string           `position:"Query" name:"Email"`
}

// CreateNetworkQuotaRequestResponse is the response struct for api CreateNetworkQuotaRequest
type CreateNetworkQuotaRequestResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateNetworkQuotaRequestRequest creates a request to invoke CreateNetworkQuotaRequest API
func CreateCreateNetworkQuotaRequestRequest() (request *CreateNetworkQuotaRequestRequest) {
	request = &CreateNetworkQuotaRequestRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Netana", "2018-10-18", "CreateNetworkQuotaRequest", "Netana", "openAPI")
	return
}

// CreateCreateNetworkQuotaRequestResponse creates a response to parse from CreateNetworkQuotaRequest response
func CreateCreateNetworkQuotaRequestResponse() (response *CreateNetworkQuotaRequestResponse) {
	response = &CreateNetworkQuotaRequestResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
