package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitTraceM3u8Job invokes the mts.SubmitTraceM3u8Job API synchronously
func (client *Client) SubmitTraceM3u8Job(request *SubmitTraceM3u8JobRequest) (response *SubmitTraceM3u8JobResponse, err error) {
	response = CreateSubmitTraceM3u8JobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitTraceM3u8JobWithChan invokes the mts.SubmitTraceM3u8Job API asynchronously
func (client *Client) SubmitTraceM3u8JobWithChan(request *SubmitTraceM3u8JobRequest) (<-chan *SubmitTraceM3u8JobResponse, <-chan error) {
	responseChan := make(chan *SubmitTraceM3u8JobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitTraceM3u8Job(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitTraceM3u8JobWithCallback invokes the mts.SubmitTraceM3u8Job API asynchronously
func (client *Client) SubmitTraceM3u8JobWithCallback(request *SubmitTraceM3u8JobRequest, callback func(response *SubmitTraceM3u8JobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitTraceM3u8JobResponse
		var err error
		defer close(result)
		response, err = client.SubmitTraceM3u8Job(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitTraceM3u8JobRequest is the request struct for api SubmitTraceM3u8Job
type SubmitTraceM3u8JobRequest struct {
	*requests.RpcRequest
	MediaId string `position:"Query" name:"MediaId"`
	Params  string `position:"Query" name:"Params"`
	Output  string `position:"Query" name:"Output"`
	Trace   string `position:"Query" name:"Trace"`
	KeyUri  string `position:"Query" name:"KeyUri"`
}

// SubmitTraceM3u8JobResponse is the response struct for api SubmitTraceM3u8Job
type SubmitTraceM3u8JobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSubmitTraceM3u8JobRequest creates a request to invoke SubmitTraceM3u8Job API
func CreateSubmitTraceM3u8JobRequest() (request *SubmitTraceM3u8JobRequest) {
	request = &SubmitTraceM3u8JobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitTraceM3u8Job", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitTraceM3u8JobResponse creates a response to parse from SubmitTraceM3u8Job response
func CreateSubmitTraceM3u8JobResponse() (response *SubmitTraceM3u8JobResponse) {
	response = &SubmitTraceM3u8JobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
