package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchTemplate invokes the mts.SearchTemplate API synchronously
func (client *Client) SearchTemplate(request *SearchTemplateRequest) (response *SearchTemplateResponse, err error) {
	response = CreateSearchTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// SearchTemplateWithChan invokes the mts.SearchTemplate API asynchronously
func (client *Client) SearchTemplateWithChan(request *SearchTemplateRequest) (<-chan *SearchTemplateResponse, <-chan error) {
	responseChan := make(chan *SearchTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchTemplateWithCallback invokes the mts.SearchTemplate API asynchronously
func (client *Client) SearchTemplateWithCallback(request *SearchTemplateRequest, callback func(response *SearchTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchTemplateResponse
		var err error
		defer close(result)
		response, err = client.SearchTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchTemplateRequest is the request struct for api SearchTemplate
type SearchTemplateRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ForFrontend          requests.Boolean `position:"Query" name:"ForFrontend"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	State                string           `position:"Query" name:"State"`
	NamePrefix           string           `position:"Query" name:"NamePrefix"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TemplateId           string           `position:"Query" name:"TemplateId"`
}

// SearchTemplateResponse is the response struct for api SearchTemplate
type SearchTemplateResponse struct {
	*responses.BaseResponse
	TotalCount   int64                        `json:"TotalCount" xml:"TotalCount"`
	PageSize     int64                        `json:"PageSize" xml:"PageSize"`
	RequestId    string                       `json:"RequestId" xml:"RequestId"`
	PageNumber   int64                        `json:"PageNumber" xml:"PageNumber"`
	TemplateList TemplateListInSearchTemplate `json:"TemplateList" xml:"TemplateList"`
}

// CreateSearchTemplateRequest creates a request to invoke SearchTemplate API
func CreateSearchTemplateRequest() (request *SearchTemplateRequest) {
	request = &SearchTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SearchTemplate", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSearchTemplateResponse creates a response to parse from SearchTemplate response
func CreateSearchTemplateResponse() (response *SearchTemplateResponse) {
	response = &SearchTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
