package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RegisterCustomView invokes the mts.RegisterCustomView API synchronously
func (client *Client) RegisterCustomView(request *RegisterCustomViewRequest) (response *RegisterCustomViewResponse, err error) {
	response = CreateRegisterCustomViewResponse()
	err = client.DoAction(request, response)
	return
}

// RegisterCustomViewWithChan invokes the mts.RegisterCustomView API asynchronously
func (client *Client) RegisterCustomViewWithChan(request *RegisterCustomViewRequest) (<-chan *RegisterCustomViewResponse, <-chan error) {
	responseChan := make(chan *RegisterCustomViewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RegisterCustomView(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RegisterCustomViewWithCallback invokes the mts.RegisterCustomView API asynchronously
func (client *Client) RegisterCustomViewWithCallback(request *RegisterCustomViewRequest, callback func(response *RegisterCustomViewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RegisterCustomViewResponse
		var err error
		defer close(result)
		response, err = client.RegisterCustomView(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RegisterCustomViewRequest is the request struct for api RegisterCustomView
type RegisterCustomViewRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Algorithm            string           `position:"Query" name:"Algorithm"`
	CustomGroupId        string           `position:"Query" name:"CustomGroupId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	CustomEntityId       string           `position:"Query" name:"CustomEntityId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ImageUrl             string           `position:"Query" name:"ImageUrl"`
}

// RegisterCustomViewResponse is the response struct for api RegisterCustomView
type RegisterCustomViewResponse struct {
	*responses.BaseResponse
	CustomViewId string `json:"CustomViewId" xml:"CustomViewId"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
}

// CreateRegisterCustomViewRequest creates a request to invoke RegisterCustomView API
func CreateRegisterCustomViewRequest() (request *RegisterCustomViewRequest) {
	request = &RegisterCustomViewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "RegisterCustomView", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRegisterCustomViewResponse creates a response to parse from RegisterCustomView response
func CreateRegisterCustomViewResponse() (response *RegisterCustomViewResponse) {
	response = &RegisterCustomViewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
