package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTraceExtractJob invokes the mts.QueryTraceExtractJob API synchronously
func (client *Client) QueryTraceExtractJob(request *QueryTraceExtractJobRequest) (response *QueryTraceExtractJobResponse, err error) {
	response = CreateQueryTraceExtractJobResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTraceExtractJobWithChan invokes the mts.QueryTraceExtractJob API asynchronously
func (client *Client) QueryTraceExtractJobWithChan(request *QueryTraceExtractJobRequest) (<-chan *QueryTraceExtractJobResponse, <-chan error) {
	responseChan := make(chan *QueryTraceExtractJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTraceExtractJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTraceExtractJobWithCallback invokes the mts.QueryTraceExtractJob API asynchronously
func (client *Client) QueryTraceExtractJobWithCallback(request *QueryTraceExtractJobRequest, callback func(response *QueryTraceExtractJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTraceExtractJobResponse
		var err error
		defer close(result)
		response, err = client.QueryTraceExtractJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTraceExtractJobRequest is the request struct for api QueryTraceExtractJob
type QueryTraceExtractJobRequest struct {
	*requests.RpcRequest
	JobId string `position:"Query" name:"JobId"`
}

// QueryTraceExtractJobResponse is the response struct for api QueryTraceExtractJob
type QueryTraceExtractJobResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Message    string `json:"Message" xml:"Message"`
	StatusCode int64  `json:"StatusCode" xml:"StatusCode"`
	Data       Data   `json:"Data" xml:"Data"`
}

// CreateQueryTraceExtractJobRequest creates a request to invoke QueryTraceExtractJob API
func CreateQueryTraceExtractJobRequest() (request *QueryTraceExtractJobRequest) {
	request = &QueryTraceExtractJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QueryTraceExtractJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryTraceExtractJobResponse creates a response to parse from QueryTraceExtractJob response
func CreateQueryTraceExtractJobResponse() (response *QueryTraceExtractJobResponse) {
	response = &QueryTraceExtractJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
