package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCustomViews invokes the mts.ListCustomViews API synchronously
func (client *Client) ListCustomViews(request *ListCustomViewsRequest) (response *ListCustomViewsResponse, err error) {
	response = CreateListCustomViewsResponse()
	err = client.DoAction(request, response)
	return
}

// ListCustomViewsWithChan invokes the mts.ListCustomViews API asynchronously
func (client *Client) ListCustomViewsWithChan(request *ListCustomViewsRequest) (<-chan *ListCustomViewsResponse, <-chan error) {
	responseChan := make(chan *ListCustomViewsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCustomViews(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCustomViewsWithCallback invokes the mts.ListCustomViews API asynchronously
func (client *Client) ListCustomViewsWithCallback(request *ListCustomViewsRequest, callback func(response *ListCustomViewsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCustomViewsResponse
		var err error
		defer close(result)
		response, err = client.ListCustomViews(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCustomViewsRequest is the request struct for api ListCustomViews
type ListCustomViewsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	Algorithm            string           `position:"Query" name:"Algorithm"`
	CustomGroupId        string           `position:"Query" name:"CustomGroupId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	CustomEntityId       string           `position:"Query" name:"CustomEntityId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ListCustomViewsResponse is the response struct for api ListCustomViews
type ListCustomViewsResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	PageNumber  int         `json:"PageNumber" xml:"PageNumber"`
	PageSize    int         `json:"PageSize" xml:"PageSize"`
	TotalCount  int64       `json:"TotalCount" xml:"TotalCount"`
	CustomViews CustomViews `json:"CustomViews" xml:"CustomViews"`
}

// CreateListCustomViewsRequest creates a request to invoke ListCustomViews API
func CreateListCustomViewsRequest() (request *ListCustomViewsRequest) {
	request = &ListCustomViewsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "ListCustomViews", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListCustomViewsResponse creates a response to parse from ListCustomViews response
func CreateListCustomViewsResponse() (response *ListCustomViewsResponse) {
	response = &ListCustomViewsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
