package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateFlowRule invokes the mse.UpdateFlowRule API synchronously
func (client *Client) UpdateFlowRule(request *UpdateFlowRuleRequest) (response *UpdateFlowRuleResponse, err error) {
	response = CreateUpdateFlowRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateFlowRuleWithChan invokes the mse.UpdateFlowRule API asynchronously
func (client *Client) UpdateFlowRuleWithChan(request *UpdateFlowRuleRequest) (<-chan *UpdateFlowRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateFlowRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateFlowRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateFlowRuleWithCallback invokes the mse.UpdateFlowRule API asynchronously
func (client *Client) UpdateFlowRuleWithCallback(request *UpdateFlowRuleRequest, callback func(response *UpdateFlowRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateFlowRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateFlowRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateFlowRuleRequest is the request struct for api UpdateFlowRule
type UpdateFlowRuleRequest struct {
	*requests.RpcRequest
	MseSessionId      string           `position:"Query" name:"MseSessionId"`
	ControlBehavior   requests.Integer `position:"Query" name:"ControlBehavior"`
	Threshold         requests.Integer `position:"Query" name:"Threshold"`
	AppName           string           `position:"Query" name:"AppName"`
	Enable            requests.Boolean `position:"Query" name:"Enable"`
	AppId             string           `position:"Query" name:"AppId"`
	Namespace         string           `position:"Query" name:"Namespace"`
	AcceptLanguage    string           `position:"Query" name:"AcceptLanguage"`
	MaxQueueingTimeMs requests.Integer `position:"Query" name:"MaxQueueingTimeMs"`
	RuleId            requests.Integer `position:"Query" name:"RuleId"`
}

// UpdateFlowRuleResponse is the response struct for api UpdateFlowRule
type UpdateFlowRuleResponse struct {
	*responses.BaseResponse
	Message   string               `json:"Message" xml:"Message"`
	RequestId string               `json:"RequestId" xml:"RequestId"`
	Code      string               `json:"Code" xml:"Code"`
	Success   bool                 `json:"Success" xml:"Success"`
	Data      DataInUpdateFlowRule `json:"Data" xml:"Data"`
}

// CreateUpdateFlowRuleRequest creates a request to invoke UpdateFlowRule API
func CreateUpdateFlowRuleRequest() (request *UpdateFlowRuleRequest) {
	request = &UpdateFlowRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateFlowRule", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateFlowRuleResponse creates a response to parse from UpdateFlowRule response
func CreateUpdateFlowRuleResponse() (response *UpdateFlowRuleResponse) {
	response = &UpdateFlowRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
