package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGatewayRouteOnAuth invokes the mse.ListGatewayRouteOnAuth API synchronously
func (client *Client) ListGatewayRouteOnAuth(request *ListGatewayRouteOnAuthRequest) (response *ListGatewayRouteOnAuthResponse, err error) {
	response = CreateListGatewayRouteOnAuthResponse()
	err = client.DoAction(request, response)
	return
}

// ListGatewayRouteOnAuthWithChan invokes the mse.ListGatewayRouteOnAuth API asynchronously
func (client *Client) ListGatewayRouteOnAuthWithChan(request *ListGatewayRouteOnAuthRequest) (<-chan *ListGatewayRouteOnAuthResponse, <-chan error) {
	responseChan := make(chan *ListGatewayRouteOnAuthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGatewayRouteOnAuth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGatewayRouteOnAuthWithCallback invokes the mse.ListGatewayRouteOnAuth API asynchronously
func (client *Client) ListGatewayRouteOnAuthWithCallback(request *ListGatewayRouteOnAuthRequest, callback func(response *ListGatewayRouteOnAuthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGatewayRouteOnAuthResponse
		var err error
		defer close(result)
		response, err = client.ListGatewayRouteOnAuth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGatewayRouteOnAuthRequest is the request struct for api ListGatewayRouteOnAuth
type ListGatewayRouteOnAuthRequest struct {
	*requests.RpcRequest
	MseSessionId    string `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string `position:"Query" name:"GatewayUniqueId"`
	Type            string `position:"Query" name:"Type"`
	AcceptLanguage  string `position:"Query" name:"AcceptLanguage"`
}

// ListGatewayRouteOnAuthResponse is the response struct for api ListGatewayRouteOnAuth
type ListGatewayRouteOnAuthResponse struct {
	*responses.BaseResponse
	RequestId      string                             `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int                                `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                             `json:"Message" xml:"Message"`
	Code           int                                `json:"Code" xml:"Code"`
	Success        bool                               `json:"Success" xml:"Success"`
	Data           []DataItemInListGatewayRouteOnAuth `json:"Data" xml:"Data"`
}

// CreateListGatewayRouteOnAuthRequest creates a request to invoke ListGatewayRouteOnAuth API
func CreateListGatewayRouteOnAuthRequest() (request *ListGatewayRouteOnAuthRequest) {
	request = &ListGatewayRouteOnAuthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListGatewayRouteOnAuth", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListGatewayRouteOnAuthResponse creates a response to parse from ListGatewayRouteOnAuth response
func CreateListGatewayRouteOnAuthResponse() (response *ListGatewayRouteOnAuthResponse) {
	response = &ListGatewayRouteOnAuthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
