package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InitializeServiceLinkRole invokes the mse.InitializeServiceLinkRole API synchronously
func (client *Client) InitializeServiceLinkRole(request *InitializeServiceLinkRoleRequest) (response *InitializeServiceLinkRoleResponse, err error) {
	response = CreateInitializeServiceLinkRoleResponse()
	err = client.DoAction(request, response)
	return
}

// InitializeServiceLinkRoleWithChan invokes the mse.InitializeServiceLinkRole API asynchronously
func (client *Client) InitializeServiceLinkRoleWithChan(request *InitializeServiceLinkRoleRequest) (<-chan *InitializeServiceLinkRoleResponse, <-chan error) {
	responseChan := make(chan *InitializeServiceLinkRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InitializeServiceLinkRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InitializeServiceLinkRoleWithCallback invokes the mse.InitializeServiceLinkRole API asynchronously
func (client *Client) InitializeServiceLinkRoleWithCallback(request *InitializeServiceLinkRoleRequest, callback func(response *InitializeServiceLinkRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InitializeServiceLinkRoleResponse
		var err error
		defer close(result)
		response, err = client.InitializeServiceLinkRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InitializeServiceLinkRoleRequest is the request struct for api InitializeServiceLinkRole
type InitializeServiceLinkRoleRequest struct {
	*requests.RpcRequest
	MseSessionId   string `position:"Query" name:"MseSessionId"`
	RoleName       string `position:"Query" name:"RoleName"`
	Token          string `position:"Query" name:"Token"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
}

// InitializeServiceLinkRoleResponse is the response struct for api InitializeServiceLinkRole
type InitializeServiceLinkRoleResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateInitializeServiceLinkRoleRequest creates a request to invoke InitializeServiceLinkRole API
func CreateInitializeServiceLinkRoleRequest() (request *InitializeServiceLinkRoleRequest) {
	request = &InitializeServiceLinkRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "InitializeServiceLinkRole", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateInitializeServiceLinkRoleResponse creates a response to parse from InitializeServiceLinkRole response
func CreateInitializeServiceLinkRoleResponse() (response *InitializeServiceLinkRoleResponse) {
	response = &InitializeServiceLinkRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
