package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetGatewayAuthConsumerDetail invokes the mse.GetGatewayAuthConsumerDetail API synchronously
func (client *Client) GetGatewayAuthConsumerDetail(request *GetGatewayAuthConsumerDetailRequest) (response *GetGatewayAuthConsumerDetailResponse, err error) {
	response = CreateGetGatewayAuthConsumerDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetGatewayAuthConsumerDetailWithChan invokes the mse.GetGatewayAuthConsumerDetail API asynchronously
func (client *Client) GetGatewayAuthConsumerDetailWithChan(request *GetGatewayAuthConsumerDetailRequest) (<-chan *GetGatewayAuthConsumerDetailResponse, <-chan error) {
	responseChan := make(chan *GetGatewayAuthConsumerDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetGatewayAuthConsumerDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetGatewayAuthConsumerDetailWithCallback invokes the mse.GetGatewayAuthConsumerDetail API asynchronously
func (client *Client) GetGatewayAuthConsumerDetailWithCallback(request *GetGatewayAuthConsumerDetailRequest, callback func(response *GetGatewayAuthConsumerDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetGatewayAuthConsumerDetailResponse
		var err error
		defer close(result)
		response, err = client.GetGatewayAuthConsumerDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetGatewayAuthConsumerDetailRequest is the request struct for api GetGatewayAuthConsumerDetail
type GetGatewayAuthConsumerDetailRequest struct {
	*requests.RpcRequest
	MseSessionId    string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	Id              requests.Integer `position:"Query" name:"Id"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
}

// GetGatewayAuthConsumerDetailResponse is the response struct for api GetGatewayAuthConsumerDetail
type GetGatewayAuthConsumerDetailResponse struct {
	*responses.BaseResponse
	RequestId      string                             `json:"RequestId" xml:"RequestId"`
	Success        bool                               `json:"Success" xml:"Success"`
	Code           int                                `json:"Code" xml:"Code"`
	ErrorCode      string                             `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int                                `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                             `json:"Message" xml:"Message"`
	DynamicCode    string                             `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string                             `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           DataInGetGatewayAuthConsumerDetail `json:"Data" xml:"Data"`
}

// CreateGetGatewayAuthConsumerDetailRequest creates a request to invoke GetGatewayAuthConsumerDetail API
func CreateGetGatewayAuthConsumerDetailRequest() (request *GetGatewayAuthConsumerDetailRequest) {
	request = &GetGatewayAuthConsumerDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "GetGatewayAuthConsumerDetail", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetGatewayAuthConsumerDetailResponse creates a response to parse from GetGatewayAuthConsumerDetail response
func CreateGetGatewayAuthConsumerDetailResponse() (response *GetGatewayAuthConsumerDetailResponse) {
	response = &GetGatewayAuthConsumerDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
