package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSecurityGroupRule invokes the mse.DeleteSecurityGroupRule API synchronously
func (client *Client) DeleteSecurityGroupRule(request *DeleteSecurityGroupRuleRequest) (response *DeleteSecurityGroupRuleResponse, err error) {
	response = CreateDeleteSecurityGroupRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSecurityGroupRuleWithChan invokes the mse.DeleteSecurityGroupRule API asynchronously
func (client *Client) DeleteSecurityGroupRuleWithChan(request *DeleteSecurityGroupRuleRequest) (<-chan *DeleteSecurityGroupRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteSecurityGroupRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSecurityGroupRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSecurityGroupRuleWithCallback invokes the mse.DeleteSecurityGroupRule API asynchronously
func (client *Client) DeleteSecurityGroupRuleWithCallback(request *DeleteSecurityGroupRuleRequest, callback func(response *DeleteSecurityGroupRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSecurityGroupRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteSecurityGroupRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSecurityGroupRuleRequest is the request struct for api DeleteSecurityGroupRule
type DeleteSecurityGroupRuleRequest struct {
	*requests.RpcRequest
	MseSessionId    string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	Id              requests.Integer `position:"Query" name:"Id"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
	CascadingDelete requests.Boolean `position:"Query" name:"CascadingDelete"`
}

// DeleteSecurityGroupRuleResponse is the response struct for api DeleteSecurityGroupRule
type DeleteSecurityGroupRuleResponse struct {
	*responses.BaseResponse
	RequestId      string                        `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int                           `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                        `json:"Message" xml:"Message"`
	Code           int                           `json:"Code" xml:"Code"`
	Success        bool                          `json:"Success" xml:"Success"`
	Data           DataInDeleteSecurityGroupRule `json:"Data" xml:"Data"`
}

// CreateDeleteSecurityGroupRuleRequest creates a request to invoke DeleteSecurityGroupRule API
func CreateDeleteSecurityGroupRuleRequest() (request *DeleteSecurityGroupRuleRequest) {
	request = &DeleteSecurityGroupRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "DeleteSecurityGroupRule", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSecurityGroupRuleResponse creates a response to parse from DeleteSecurityGroupRule response
func CreateDeleteSecurityGroupRuleResponse() (response *DeleteSecurityGroupRuleResponse) {
	response = &DeleteSecurityGroupRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
