package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMcubeNebulaTask invokes the mpaas.CreateMcubeNebulaTask API synchronously
func (client *Client) CreateMcubeNebulaTask(request *CreateMcubeNebulaTaskRequest) (response *CreateMcubeNebulaTaskResponse, err error) {
	response = CreateCreateMcubeNebulaTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMcubeNebulaTaskWithChan invokes the mpaas.CreateMcubeNebulaTask API asynchronously
func (client *Client) CreateMcubeNebulaTaskWithChan(request *CreateMcubeNebulaTaskRequest) (<-chan *CreateMcubeNebulaTaskResponse, <-chan error) {
	responseChan := make(chan *CreateMcubeNebulaTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMcubeNebulaTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMcubeNebulaTaskWithCallback invokes the mpaas.CreateMcubeNebulaTask API asynchronously
func (client *Client) CreateMcubeNebulaTaskWithCallback(request *CreateMcubeNebulaTaskRequest, callback func(response *CreateMcubeNebulaTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMcubeNebulaTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateMcubeNebulaTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMcubeNebulaTaskRequest is the request struct for api CreateMcubeNebulaTask
type CreateMcubeNebulaTaskRequest struct {
	*requests.RpcRequest
	GreyEndtime      string           `position:"Body" name:"GreyEndtime"`
	SerialVersionUID requests.Integer `position:"Body" name:"SerialVersionUID"`
	ProductId        string           `position:"Body" name:"ProductId"`
	UpgradeProgress  string           `position:"Body" name:"UpgradeProgress"`
	Modifier         string           `position:"Body" name:"Modifier"`
	PackageId        requests.Integer `position:"Body" name:"PackageId"`
	TaskName         string           `position:"Body" name:"TaskName"`
	Memo             string           `position:"Body" name:"Memo"`
	GmtModified      string           `position:"Body" name:"GmtModified"`
	ReleaseVersion   string           `position:"Body" name:"ReleaseVersion"`
	SyncResult       string           `position:"Body" name:"SyncResult"`
	UpgradeNoticeNum requests.Integer `position:"Body" name:"UpgradeNoticeNum"`
	Id               requests.Integer `position:"Body" name:"Id"`
	TaskType         requests.Integer `position:"Body" name:"TaskType"`
	PublishType      requests.Integer `position:"Body" name:"PublishType"`
	GreyNum          requests.Integer `position:"Body" name:"GreyNum"`
	AppCode          string           `position:"Body" name:"AppCode"`
	Status           requests.Integer `position:"Body" name:"Status"`
	WorkspaceId      string           `position:"Body" name:"WorkspaceId"`
	GmtModifiedStr   string           `position:"Body" name:"GmtModifiedStr"`
	GreyUrl          string           `position:"Body" name:"GreyUrl"`
	ProductVersion   string           `position:"Body" name:"ProductVersion"`
	Percent          requests.Integer `position:"Body" name:"Percent"`
	Platform         string           `position:"Body" name:"Platform"`
	GreyConfigInfo   string           `position:"Body" name:"GreyConfigInfo"`
	TaskStatus       requests.Integer `position:"Body" name:"TaskStatus"`
	ResIds           string           `position:"Body" name:"ResIds"`
	TenantId         string           `position:"Body" name:"TenantId"`
	PublishMode      requests.Integer `position:"Body" name:"PublishMode"`
	WhitelistIds     string           `position:"Body" name:"WhitelistIds"`
	GreyEndtimeStr   string           `position:"Body" name:"GreyEndtimeStr"`
	Creator          string           `position:"Body" name:"Creator"`
	SyncMode         string           `position:"Body" name:"SyncMode"`
	GmtCreate        string           `position:"Body" name:"GmtCreate"`
	BizType          string           `position:"Body" name:"BizType"`
	TaskVersion      requests.Integer `position:"Body" name:"TaskVersion"`
	AppId            string           `position:"Body" name:"AppId"`
	GreyEndtimeData  string           `position:"Body" name:"GreyEndtimeData"`
}

// CreateMcubeNebulaTaskResponse is the response struct for api CreateMcubeNebulaTask
type CreateMcubeNebulaTaskResponse struct {
	*responses.BaseResponse
	ResultMessage               string                      `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode                  string                      `json:"ResultCode" xml:"ResultCode"`
	RequestId                   string                      `json:"RequestId" xml:"RequestId"`
	CreateMcubeNebulaTaskResult CreateMcubeNebulaTaskResult `json:"CreateMcubeNebulaTaskResult" xml:"CreateMcubeNebulaTaskResult"`
}

// CreateCreateMcubeNebulaTaskRequest creates a request to invoke CreateMcubeNebulaTask API
func CreateCreateMcubeNebulaTaskRequest() (request *CreateMcubeNebulaTaskRequest) {
	request = &CreateMcubeNebulaTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMcubeNebulaTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMcubeNebulaTaskResponse creates a response to parse from CreateMcubeNebulaTask response
func CreateCreateMcubeNebulaTaskResponse() (response *CreateMcubeNebulaTaskResponse) {
	response = &CreateMcubeNebulaTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
