package mopen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MoPenFindGroup invokes the mopen.MoPenFindGroup API synchronously
// api document: https://help.aliyun.com/api/mopen/mopenfindgroup.html
func (client *Client) MoPenFindGroup(request *MoPenFindGroupRequest) (response *MoPenFindGroupResponse, err error) {
	response = CreateMoPenFindGroupResponse()
	err = client.DoAction(request, response)
	return
}

// MoPenFindGroupWithChan invokes the mopen.MoPenFindGroup API asynchronously
// api document: https://help.aliyun.com/api/mopen/mopenfindgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MoPenFindGroupWithChan(request *MoPenFindGroupRequest) (<-chan *MoPenFindGroupResponse, <-chan error) {
	responseChan := make(chan *MoPenFindGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MoPenFindGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MoPenFindGroupWithCallback invokes the mopen.MoPenFindGroup API asynchronously
// api document: https://help.aliyun.com/api/mopen/mopenfindgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MoPenFindGroupWithCallback(request *MoPenFindGroupRequest, callback func(response *MoPenFindGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MoPenFindGroupResponse
		var err error
		defer close(result)
		response, err = client.MoPenFindGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MoPenFindGroupRequest is the request struct for api MoPenFindGroup
type MoPenFindGroupRequest struct {
	*requests.RpcRequest
	Creator string `position:"Body" name:"Creator"`
}

// MoPenFindGroupResponse is the response struct for api MoPenFindGroup
type MoPenFindGroupResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Code        int    `json:"Code" xml:"Code"`
	Success     string `json:"Success" xml:"Success"`
	Description string `json:"Description" xml:"Description"`
	Message     string `json:"Message" xml:"Message"`
	Data        Data   `json:"Data" xml:"Data"`
}

// CreateMoPenFindGroupRequest creates a request to invoke MoPenFindGroup API
func CreateMoPenFindGroupRequest() (request *MoPenFindGroupRequest) {
	request = &MoPenFindGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("MoPen", "2018-02-11", "MoPenFindGroup", "mopen", "openAPI")
	return
}

// CreateMoPenFindGroupResponse creates a response to parse from MoPenFindGroup response
func CreateMoPenFindGroupResponse() (response *MoPenFindGroupResponse) {
	response = &MoPenFindGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
