package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDeviceInfo invokes the lto.DescribeDeviceInfo API synchronously
func (client *Client) DescribeDeviceInfo(request *DescribeDeviceInfoRequest) (response *DescribeDeviceInfoResponse, err error) {
	response = CreateDescribeDeviceInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDeviceInfoWithChan invokes the lto.DescribeDeviceInfo API asynchronously
func (client *Client) DescribeDeviceInfoWithChan(request *DescribeDeviceInfoRequest) (<-chan *DescribeDeviceInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeDeviceInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDeviceInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDeviceInfoWithCallback invokes the lto.DescribeDeviceInfo API asynchronously
func (client *Client) DescribeDeviceInfoWithCallback(request *DescribeDeviceInfoRequest, callback func(response *DescribeDeviceInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDeviceInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeDeviceInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDeviceInfoRequest is the request struct for api DescribeDeviceInfo
type DescribeDeviceInfoRequest struct {
	*requests.RpcRequest
}

// DescribeDeviceInfoResponse is the response struct for api DescribeDeviceInfo
type DescribeDeviceInfoResponse struct {
	*responses.BaseResponse
	Code           string                   `json:"Code" xml:"Code"`
	HttpStatusCode int                      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                   `json:"Message" xml:"Message"`
	RequestId      string                   `json:"RequestId" xml:"RequestId"`
	Success        bool                     `json:"Success" xml:"Success"`
	Data           DataInDescribeDeviceInfo `json:"Data" xml:"Data"`
}

// CreateDescribeDeviceInfoRequest creates a request to invoke DescribeDeviceInfo API
func CreateDescribeDeviceInfoRequest() (request *DescribeDeviceInfoRequest) {
	request = &DescribeDeviceInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "DescribeDeviceInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDeviceInfoResponse creates a response to parse from DescribeDeviceInfo response
func CreateDescribeDeviceInfoResponse() (response *DescribeDeviceInfoResponse) {
	response = &DescribeDeviceInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
