package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDashboardMemberApiInfo invokes the lto.DescribeDashboardMemberApiInfo API synchronously
func (client *Client) DescribeDashboardMemberApiInfo(request *DescribeDashboardMemberApiInfoRequest) (response *DescribeDashboardMemberApiInfoResponse, err error) {
	response = CreateDescribeDashboardMemberApiInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDashboardMemberApiInfoWithChan invokes the lto.DescribeDashboardMemberApiInfo API asynchronously
func (client *Client) DescribeDashboardMemberApiInfoWithChan(request *DescribeDashboardMemberApiInfoRequest) (<-chan *DescribeDashboardMemberApiInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeDashboardMemberApiInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDashboardMemberApiInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDashboardMemberApiInfoWithCallback invokes the lto.DescribeDashboardMemberApiInfo API asynchronously
func (client *Client) DescribeDashboardMemberApiInfoWithCallback(request *DescribeDashboardMemberApiInfoRequest, callback func(response *DescribeDashboardMemberApiInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDashboardMemberApiInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeDashboardMemberApiInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDashboardMemberApiInfoRequest is the request struct for api DescribeDashboardMemberApiInfo
type DescribeDashboardMemberApiInfoRequest struct {
	*requests.RpcRequest
	EndTime    requests.Integer `position:"Query" name:"EndTime"`
	StartTime  requests.Integer `position:"Query" name:"StartTime"`
	BizChainId string           `position:"Query" name:"BizChainId"`
}

// DescribeDashboardMemberApiInfoResponse is the response struct for api DescribeDashboardMemberApiInfo
type DescribeDashboardMemberApiInfoResponse struct {
	*responses.BaseResponse
	Code           string     `json:"Code" xml:"Code"`
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string     `json:"Message" xml:"Message"`
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	Success        bool       `json:"Success" xml:"Success"`
	Data           []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeDashboardMemberApiInfoRequest creates a request to invoke DescribeDashboardMemberApiInfo API
func CreateDescribeDashboardMemberApiInfoRequest() (request *DescribeDashboardMemberApiInfoRequest) {
	request = &DescribeDashboardMemberApiInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "DescribeDashboardMemberApiInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDashboardMemberApiInfoResponse creates a response to parse from DescribeDashboardMemberApiInfo response
func CreateDescribeDashboardMemberApiInfoResponse() (response *DescribeDashboardMemberApiInfoResponse) {
	response = &DescribeDashboardMemberApiInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
