package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddDeviceGroup invokes the lto.AddDeviceGroup API synchronously
func (client *Client) AddDeviceGroup(request *AddDeviceGroupRequest) (response *AddDeviceGroupResponse, err error) {
	response = CreateAddDeviceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// AddDeviceGroupWithChan invokes the lto.AddDeviceGroup API asynchronously
func (client *Client) AddDeviceGroupWithChan(request *AddDeviceGroupRequest) (<-chan *AddDeviceGroupResponse, <-chan error) {
	responseChan := make(chan *AddDeviceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddDeviceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddDeviceGroupWithCallback invokes the lto.AddDeviceGroup API asynchronously
func (client *Client) AddDeviceGroupWithCallback(request *AddDeviceGroupRequest, callback func(response *AddDeviceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddDeviceGroupResponse
		var err error
		defer close(result)
		response, err = client.AddDeviceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddDeviceGroupRequest is the request struct for api AddDeviceGroup
type AddDeviceGroupRequest struct {
	*requests.RpcRequest
	Remark          string           `position:"Query" name:"Remark"`
	ProductKey      string           `position:"Query" name:"ProductKey"`
	AuthorizedCount requests.Integer `position:"Query" name:"AuthorizedCount"`
}

// AddDeviceGroupResponse is the response struct for api AddDeviceGroup
type AddDeviceGroupResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateAddDeviceGroupRequest creates a request to invoke AddDeviceGroup API
func CreateAddDeviceGroupRequest() (request *AddDeviceGroupRequest) {
	request = &AddDeviceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "AddDeviceGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateAddDeviceGroupResponse creates a response to parse from AddDeviceGroup response
func CreateAddDeviceGroupResponse() (response *AddDeviceGroupResponse) {
	response = &AddDeviceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
