package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadMPCoSPhaseDigestInfoByDevice invokes the ltl.UploadMPCoSPhaseDigestInfoByDevice API synchronously
func (client *Client) UploadMPCoSPhaseDigestInfoByDevice(request *UploadMPCoSPhaseDigestInfoByDeviceRequest) (response *UploadMPCoSPhaseDigestInfoByDeviceResponse, err error) {
	response = CreateUploadMPCoSPhaseDigestInfoByDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// UploadMPCoSPhaseDigestInfoByDeviceWithChan invokes the ltl.UploadMPCoSPhaseDigestInfoByDevice API asynchronously
func (client *Client) UploadMPCoSPhaseDigestInfoByDeviceWithChan(request *UploadMPCoSPhaseDigestInfoByDeviceRequest) (<-chan *UploadMPCoSPhaseDigestInfoByDeviceResponse, <-chan error) {
	responseChan := make(chan *UploadMPCoSPhaseDigestInfoByDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadMPCoSPhaseDigestInfoByDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadMPCoSPhaseDigestInfoByDeviceWithCallback invokes the ltl.UploadMPCoSPhaseDigestInfoByDevice API asynchronously
func (client *Client) UploadMPCoSPhaseDigestInfoByDeviceWithCallback(request *UploadMPCoSPhaseDigestInfoByDeviceRequest, callback func(response *UploadMPCoSPhaseDigestInfoByDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadMPCoSPhaseDigestInfoByDeviceResponse
		var err error
		defer close(result)
		response, err = client.UploadMPCoSPhaseDigestInfoByDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadMPCoSPhaseDigestInfoByDeviceRequest is the request struct for api UploadMPCoSPhaseDigestInfoByDevice
type UploadMPCoSPhaseDigestInfoByDeviceRequest struct {
	*requests.RpcRequest
	IotSignature         string                 `position:"Query" name:"IotSignature"`
	IotAuthType          string                 `position:"Query" name:"IotAuthType"`
	IotIdSource          string                 `position:"Query" name:"IotIdSource"`
	PhaseData            string                 `position:"Query" name:"PhaseData"`
	PhaseId              string                 `position:"Query" name:"PhaseId"`
	ApiVersion           string                 `position:"Query" name:"ApiVersion"`
	BizChainId           string                 `position:"Query" name:"BizChainId"`
	DataKey              string                 `position:"Query" name:"DataKey"`
	DataSeq              string                 `position:"Query" name:"DataSeq"`
	IotId                string                 `position:"Query" name:"IotId"`
	PhaseGroupId         string                 `position:"Query" name:"PhaseGroupId"`
	IotDataDigest        string                 `position:"Query" name:"IotDataDigest"`
	IotIdServiceProvider string                 `position:"Query" name:"IotIdServiceProvider"`
	RelatedDataList      map[string]interface{} `position:"Query" name:"RelatedDataList"`
}

// UploadMPCoSPhaseDigestInfoByDeviceResponse is the response struct for api UploadMPCoSPhaseDigestInfoByDevice
type UploadMPCoSPhaseDigestInfoByDeviceResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUploadMPCoSPhaseDigestInfoByDeviceRequest creates a request to invoke UploadMPCoSPhaseDigestInfoByDevice API
func CreateUploadMPCoSPhaseDigestInfoByDeviceRequest() (request *UploadMPCoSPhaseDigestInfoByDeviceRequest) {
	request = &UploadMPCoSPhaseDigestInfoByDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "UploadMPCoSPhaseDigestInfoByDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateUploadMPCoSPhaseDigestInfoByDeviceResponse creates a response to parse from UploadMPCoSPhaseDigestInfoByDevice response
func CreateUploadMPCoSPhaseDigestInfoByDeviceResponse() (response *UploadMPCoSPhaseDigestInfoByDeviceResponse) {
	response = &UploadMPCoSPhaseDigestInfoByDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
