package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyMPCoSPhase invokes the ltl.ModifyMPCoSPhase API synchronously
func (client *Client) ModifyMPCoSPhase(request *ModifyMPCoSPhaseRequest) (response *ModifyMPCoSPhaseResponse, err error) {
	response = CreateModifyMPCoSPhaseResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyMPCoSPhaseWithChan invokes the ltl.ModifyMPCoSPhase API asynchronously
func (client *Client) ModifyMPCoSPhaseWithChan(request *ModifyMPCoSPhaseRequest) (<-chan *ModifyMPCoSPhaseResponse, <-chan error) {
	responseChan := make(chan *ModifyMPCoSPhaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyMPCoSPhase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyMPCoSPhaseWithCallback invokes the ltl.ModifyMPCoSPhase API asynchronously
func (client *Client) ModifyMPCoSPhaseWithCallback(request *ModifyMPCoSPhaseRequest, callback func(response *ModifyMPCoSPhaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyMPCoSPhaseResponse
		var err error
		defer close(result)
		response, err = client.ModifyMPCoSPhase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyMPCoSPhaseRequest is the request struct for api ModifyMPCoSPhase
type ModifyMPCoSPhaseRequest struct {
	*requests.RpcRequest
	Name       string `position:"Query" name:"Name"`
	PhaseId    string `position:"Query" name:"PhaseId"`
	ApiVersion string `position:"Query" name:"ApiVersion"`
	Remark     string `position:"Query" name:"Remark"`
	BizChainId string `position:"Query" name:"BizChainId"`
}

// ModifyMPCoSPhaseResponse is the response struct for api ModifyMPCoSPhase
type ModifyMPCoSPhaseResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateModifyMPCoSPhaseRequest creates a request to invoke ModifyMPCoSPhase API
func CreateModifyMPCoSPhaseRequest() (request *ModifyMPCoSPhaseRequest) {
	request = &ModifyMPCoSPhaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "ModifyMPCoSPhase", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyMPCoSPhaseResponse creates a response to parse from ModifyMPCoSPhase response
func CreateModifyMPCoSPhaseResponse() (response *ModifyMPCoSPhaseResponse) {
	response = &ModifyMPCoSPhaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
