package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecoverLiveMessageDeletedGroup invokes the live.RecoverLiveMessageDeletedGroup API synchronously
func (client *Client) RecoverLiveMessageDeletedGroup(request *RecoverLiveMessageDeletedGroupRequest) (response *RecoverLiveMessageDeletedGroupResponse, err error) {
	response = CreateRecoverLiveMessageDeletedGroupResponse()
	err = client.DoAction(request, response)
	return
}

// RecoverLiveMessageDeletedGroupWithChan invokes the live.RecoverLiveMessageDeletedGroup API asynchronously
func (client *Client) RecoverLiveMessageDeletedGroupWithChan(request *RecoverLiveMessageDeletedGroupRequest) (<-chan *RecoverLiveMessageDeletedGroupResponse, <-chan error) {
	responseChan := make(chan *RecoverLiveMessageDeletedGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecoverLiveMessageDeletedGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecoverLiveMessageDeletedGroupWithCallback invokes the live.RecoverLiveMessageDeletedGroup API asynchronously
func (client *Client) RecoverLiveMessageDeletedGroupWithCallback(request *RecoverLiveMessageDeletedGroupRequest, callback func(response *RecoverLiveMessageDeletedGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecoverLiveMessageDeletedGroupResponse
		var err error
		defer close(result)
		response, err = client.RecoverLiveMessageDeletedGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecoverLiveMessageDeletedGroupRequest is the request struct for api RecoverLiveMessageDeletedGroup
type RecoverLiveMessageDeletedGroupRequest struct {
	*requests.RpcRequest
	GroupId    string `position:"Query" name:"GroupId"`
	DataCenter string `position:"Query" name:"DataCenter"`
	AppId      string `position:"Query" name:"AppId"`
}

// RecoverLiveMessageDeletedGroupResponse is the response struct for api RecoverLiveMessageDeletedGroup
type RecoverLiveMessageDeletedGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	GroupId   string `json:"GroupId" xml:"GroupId"`
}

// CreateRecoverLiveMessageDeletedGroupRequest creates a request to invoke RecoverLiveMessageDeletedGroup API
func CreateRecoverLiveMessageDeletedGroupRequest() (request *RecoverLiveMessageDeletedGroupRequest) {
	request = &RecoverLiveMessageDeletedGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "RecoverLiveMessageDeletedGroup", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecoverLiveMessageDeletedGroupResponse creates a response to parse from RecoverLiveMessageDeletedGroup response
func CreateRecoverLiveMessageDeletedGroupResponse() (response *RecoverLiveMessageDeletedGroupResponse) {
	response = &RecoverLiveMessageDeletedGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
