package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EditPlaylist invokes the live.EditPlaylist API synchronously
func (client *Client) EditPlaylist(request *EditPlaylistRequest) (response *EditPlaylistResponse, err error) {
	response = CreateEditPlaylistResponse()
	err = client.DoAction(request, response)
	return
}

// EditPlaylistWithChan invokes the live.EditPlaylist API asynchronously
func (client *Client) EditPlaylistWithChan(request *EditPlaylistRequest) (<-chan *EditPlaylistResponse, <-chan error) {
	responseChan := make(chan *EditPlaylistResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EditPlaylist(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EditPlaylistWithCallback invokes the live.EditPlaylist API asynchronously
func (client *Client) EditPlaylistWithCallback(request *EditPlaylistRequest, callback func(response *EditPlaylistResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EditPlaylistResponse
		var err error
		defer close(result)
		response, err = client.EditPlaylist(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EditPlaylistRequest is the request struct for api EditPlaylist
type EditPlaylistRequest struct {
	*requests.RpcRequest
	ProgramItems  string           `position:"Query" name:"ProgramItems"`
	ProgramId     string           `position:"Query" name:"ProgramId"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	ProgramConfig string           `position:"Query" name:"ProgramConfig"`
}

// EditPlaylistResponse is the response struct for api EditPlaylist
type EditPlaylistResponse struct {
	*responses.BaseResponse
	CasterId  string `json:"CasterId" xml:"CasterId"`
	ProgramId string `json:"ProgramId" xml:"ProgramId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Items     Items  `json:"Items" xml:"Items"`
}

// CreateEditPlaylistRequest creates a request to invoke EditPlaylist API
func CreateEditPlaylistRequest() (request *EditPlaylistRequest) {
	request = &EditPlaylistRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "EditPlaylist", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEditPlaylistResponse creates a response to parse from EditPlaylist response
func CreateEditPlaylistResponse() (response *EditPlaylistResponse) {
	response = &EditPlaylistResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
