package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BanLiveMessageGroup invokes the live.BanLiveMessageGroup API synchronously
func (client *Client) BanLiveMessageGroup(request *BanLiveMessageGroupRequest) (response *BanLiveMessageGroupResponse, err error) {
	response = CreateBanLiveMessageGroupResponse()
	err = client.DoAction(request, response)
	return
}

// BanLiveMessageGroupWithChan invokes the live.BanLiveMessageGroup API asynchronously
func (client *Client) BanLiveMessageGroupWithChan(request *BanLiveMessageGroupRequest) (<-chan *BanLiveMessageGroupResponse, <-chan error) {
	responseChan := make(chan *BanLiveMessageGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BanLiveMessageGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BanLiveMessageGroupWithCallback invokes the live.BanLiveMessageGroup API asynchronously
func (client *Client) BanLiveMessageGroupWithCallback(request *BanLiveMessageGroupRequest, callback func(response *BanLiveMessageGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BanLiveMessageGroupResponse
		var err error
		defer close(result)
		response, err = client.BanLiveMessageGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BanLiveMessageGroupRequest is the request struct for api BanLiveMessageGroup
type BanLiveMessageGroupRequest struct {
	*requests.RpcRequest
	GroupId     string    `position:"Query" name:"GroupId"`
	ExceptUsers *[]string `position:"Query" name:"ExceptUsers"  type:"Repeated"`
	DataCenter  string    `position:"Query" name:"DataCenter"`
	AppId       string    `position:"Query" name:"AppId"`
}

// BanLiveMessageGroupResponse is the response struct for api BanLiveMessageGroup
type BanLiveMessageGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBanLiveMessageGroupRequest creates a request to invoke BanLiveMessageGroup API
func CreateBanLiveMessageGroupRequest() (request *BanLiveMessageGroupRequest) {
	request = &BanLiveMessageGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "BanLiveMessageGroup", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBanLiveMessageGroupResponse creates a response to parse from BanLiveMessageGroup response
func CreateBanLiveMessageGroupResponse() (response *BanLiveMessageGroupResponse) {
	response = &BanLiveMessageGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
