package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddLiveAIProduceRules invokes the live.AddLiveAIProduceRules API synchronously
func (client *Client) AddLiveAIProduceRules(request *AddLiveAIProduceRulesRequest) (response *AddLiveAIProduceRulesResponse, err error) {
	response = CreateAddLiveAIProduceRulesResponse()
	err = client.DoAction(request, response)
	return
}

// AddLiveAIProduceRulesWithChan invokes the live.AddLiveAIProduceRules API asynchronously
func (client *Client) AddLiveAIProduceRulesWithChan(request *AddLiveAIProduceRulesRequest) (<-chan *AddLiveAIProduceRulesResponse, <-chan error) {
	responseChan := make(chan *AddLiveAIProduceRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddLiveAIProduceRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddLiveAIProduceRulesWithCallback invokes the live.AddLiveAIProduceRules API asynchronously
func (client *Client) AddLiveAIProduceRulesWithCallback(request *AddLiveAIProduceRulesRequest, callback func(response *AddLiveAIProduceRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddLiveAIProduceRulesResponse
		var err error
		defer close(result)
		response, err = client.AddLiveAIProduceRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddLiveAIProduceRulesRequest is the request struct for api AddLiveAIProduceRules
type AddLiveAIProduceRulesRequest struct {
	*requests.RpcRequest
	Description  string           `position:"Query" name:"Description"`
	Suffix       string           `position:"Query" name:"Suffix"`
	SubtitleName string           `position:"Query" name:"SubtitleName"`
	App          string           `position:"Query" name:"App"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	IsLazy       requests.Boolean `position:"Query" name:"IsLazy"`
	StudioName   string           `position:"Query" name:"StudioName"`
	LiveTemplate string           `position:"Query" name:"LiveTemplate"`
	Domain       string           `position:"Query" name:"Domain"`
	IsOrigin     requests.Boolean `position:"Query" name:"IsOrigin"`
}

// AddLiveAIProduceRulesResponse is the response struct for api AddLiveAIProduceRules
type AddLiveAIProduceRulesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	RulesId   string `json:"RulesId" xml:"RulesId"`
}

// CreateAddLiveAIProduceRulesRequest creates a request to invoke AddLiveAIProduceRules API
func CreateAddLiveAIProduceRulesRequest() (request *AddLiveAIProduceRulesRequest) {
	request = &AddLiveAIProduceRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddLiveAIProduceRules", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddLiveAIProduceRulesResponse creates a response to parse from AddLiveAIProduceRules response
func CreateAddLiveAIProduceRulesResponse() (response *AddLiveAIProduceRulesResponse) {
	response = &AddLiveAIProduceRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
