package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefreshGbSubDeviceList invokes the linkvisual.RefreshGbSubDeviceList API synchronously
func (client *Client) RefreshGbSubDeviceList(request *RefreshGbSubDeviceListRequest) (response *RefreshGbSubDeviceListResponse, err error) {
	response = CreateRefreshGbSubDeviceListResponse()
	err = client.DoAction(request, response)
	return
}

// RefreshGbSubDeviceListWithChan invokes the linkvisual.RefreshGbSubDeviceList API asynchronously
func (client *Client) RefreshGbSubDeviceListWithChan(request *RefreshGbSubDeviceListRequest) (<-chan *RefreshGbSubDeviceListResponse, <-chan error) {
	responseChan := make(chan *RefreshGbSubDeviceListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefreshGbSubDeviceList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefreshGbSubDeviceListWithCallback invokes the linkvisual.RefreshGbSubDeviceList API asynchronously
func (client *Client) RefreshGbSubDeviceListWithCallback(request *RefreshGbSubDeviceListRequest, callback func(response *RefreshGbSubDeviceListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefreshGbSubDeviceListResponse
		var err error
		defer close(result)
		response, err = client.RefreshGbSubDeviceList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefreshGbSubDeviceListRequest is the request struct for api RefreshGbSubDeviceList
type RefreshGbSubDeviceListRequest struct {
	*requests.RpcRequest
	IotId         string `position:"Query" name:"IotId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// RefreshGbSubDeviceListResponse is the response struct for api RefreshGbSubDeviceList
type RefreshGbSubDeviceListResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateRefreshGbSubDeviceListRequest creates a request to invoke RefreshGbSubDeviceList API
func CreateRefreshGbSubDeviceListRequest() (request *RefreshGbSubDeviceListRequest) {
	request = &RefreshGbSubDeviceListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "RefreshGbSubDeviceList", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRefreshGbSubDeviceListResponse creates a response to parse from RefreshGbSubDeviceList response
func CreateRefreshGbSubDeviceListResponse() (response *RefreshGbSubDeviceListResponse) {
	response = &RefreshGbSubDeviceListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
