package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryPictureSearchJobResult invokes the linkvisual.QueryPictureSearchJobResult API synchronously
func (client *Client) QueryPictureSearchJobResult(request *QueryPictureSearchJobResultRequest) (response *QueryPictureSearchJobResultResponse, err error) {
	response = CreateQueryPictureSearchJobResultResponse()
	err = client.DoAction(request, response)
	return
}

// QueryPictureSearchJobResultWithChan invokes the linkvisual.QueryPictureSearchJobResult API asynchronously
func (client *Client) QueryPictureSearchJobResultWithChan(request *QueryPictureSearchJobResultRequest) (<-chan *QueryPictureSearchJobResultResponse, <-chan error) {
	responseChan := make(chan *QueryPictureSearchJobResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryPictureSearchJobResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryPictureSearchJobResultWithCallback invokes the linkvisual.QueryPictureSearchJobResult API asynchronously
func (client *Client) QueryPictureSearchJobResultWithCallback(request *QueryPictureSearchJobResultRequest, callback func(response *QueryPictureSearchJobResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryPictureSearchJobResultResponse
		var err error
		defer close(result)
		response, err = client.QueryPictureSearchJobResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryPictureSearchJobResultRequest is the request struct for api QueryPictureSearchJobResult
type QueryPictureSearchJobResultRequest struct {
	*requests.RpcRequest
	JobId         string           `position:"Query" name:"JobId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage   requests.Integer `position:"Query" name:"CurrentPage"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	AppInstanceId string           `position:"Query" name:"AppInstanceId"`
}

// QueryPictureSearchJobResultResponse is the response struct for api QueryPictureSearchJobResult
type QueryPictureSearchJobResultResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryPictureSearchJobResultRequest creates a request to invoke QueryPictureSearchJobResult API
func CreateQueryPictureSearchJobResultRequest() (request *QueryPictureSearchJobResultRequest) {
	request = &QueryPictureSearchJobResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryPictureSearchJobResult", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryPictureSearchJobResultResponse creates a response to parse from QueryPictureSearchJobResult response
func CreateQueryPictureSearchJobResultResponse() (response *QueryPictureSearchJobResultResponse) {
	response = &QueryPictureSearchJobResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
