package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRecord invokes the linkvisual.DeleteRecord API synchronously
func (client *Client) DeleteRecord(request *DeleteRecordRequest) (response *DeleteRecordResponse, err error) {
	response = CreateDeleteRecordResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRecordWithChan invokes the linkvisual.DeleteRecord API asynchronously
func (client *Client) DeleteRecordWithChan(request *DeleteRecordRequest) (<-chan *DeleteRecordResponse, <-chan error) {
	responseChan := make(chan *DeleteRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRecordWithCallback invokes the linkvisual.DeleteRecord API asynchronously
func (client *Client) DeleteRecordWithCallback(request *DeleteRecordRequest, callback func(response *DeleteRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRecordResponse
		var err error
		defer close(result)
		response, err = client.DeleteRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRecordRequest is the request struct for api DeleteRecord
type DeleteRecordRequest struct {
	*requests.RpcRequest
	IotId         string    `position:"Query" name:"IotId"`
	IotInstanceId string    `position:"Query" name:"IotInstanceId"`
	ProductKey    string    `position:"Query" name:"ProductKey"`
	FileNameList  *[]string `position:"Query" name:"FileNameList"  type:"Repeated"`
	ApiProduct    string    `position:"Body" name:"ApiProduct"`
	ApiRevision   string    `position:"Body" name:"ApiRevision"`
	DeviceName    string    `position:"Query" name:"DeviceName"`
}

// DeleteRecordResponse is the response struct for api DeleteRecord
type DeleteRecordResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateDeleteRecordRequest creates a request to invoke DeleteRecord API
func CreateDeleteRecordRequest() (request *DeleteRecordRequest) {
	request = &DeleteRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "DeleteRecord", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteRecordResponse creates a response to parse from DeleteRecord response
func CreateDeleteRecordResponse() (response *DeleteRecordResponse) {
	response = &DeleteRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
